 ;************************************************************************
 ;20220419 C64 ASDK for Atari 2600 SuperCharger BASIC cross Development **
 ;************************************************************************
 ; ;-------C64 NTSC Model M 60 Hz used in R&D and benchmarking tests     
 ; ;-------PAL Models will have more serene gameplay at 50 Hz!   
 ;------------------------------------------------------------------------
;-----------------------------------------------------------
;----VM Compatible with Atari SuperCharger & Flashback BASIC        
;----And Abstract Assembly ASDK for the Atari 2600 VCS   ---
;----a FREE Abstract Assembly/BASIC Programming Framework---
;----For the Atari 2600 VCS                             ----
;----GOLD EDITION VERSION 2.1                           ----
;-----------------------------------------------------------
;----BROUGHT TO YOU BY RELATIONALFRAMEWORK.COM          ----
;-----------------------------------------------------------
; Write fast Atari games on the C64 and Atari 2600!
; Use Display Lists like Atari Home Computers on the C64!
; Cross compile your program to run on the Atari 2600!
; Not a Knock Off of the 80's vaporware this is real...  
;-----------------------------------------------------------
;----------------- SYS 4378 --------------------------------
;----20220516 Fix intermittent freeze shown on 10 Line BLITZ 
;----20220516 Excellent IRQ suggestion from C64 programmer Bjonte - setup dummy nmi to turn them all off 
;[sprites loaded 60x per second, architecture fix: on c64 they should piggyback sprite buffer load or RESPO/RESP1 Shadow register reload] 
;----20230119 Excellent idea from Lemon programmer Lasse, fixed PAL freeze bug
;----20230122 Tuning enhancements for TIA to SID chiptune tracker/sequencer 
;--------------------------------------------------------------------------------------
;20230407 seeding d4017 [54295], full resonance and all filters activated (missed)
;--------------------------------------------------------------------------------------
;20231105 MBR Motion Blur Reduction Filter added but commented, Search for this date string to find the two sections (6 and 4 lines) to uncomment to activate
;--------------------------------------------------------------------------------------

 processor 6502

; Embedded BASIC loader AUTO STARTS the Gameloader64 standalone prg binary:
;10 SYS 4378; $0801 = 2049


 ORG $0801
; $0C $08 = $080C 2-byte pointer to the next line of BASIC code
; $0A = 10; 2-byte line number low byte ($000A = 10)
; $00 = 0 ; 2-byte line number high bye
; $9E = SYS BASIC token
; $20 = [space]
; $34 = 4 , $33 = 3, $37 = 7, $38 = 8 (ASCII encoded numbers for decimal starting address)
; $0 = end of line
; $00 $00 = 2-byte pointer to the next line of BASIC code ($0000 = end of program)
 
 .byte $0C,$08,$0A,$00,$9E,$20,$34,$33,$37,$38,$00,$00,$00
 ;.byte $0C,$08,$0A,$00,$9E,$20,$38,$34,$37,$34,$00,$00,$00

; .byte $0C,$08,$0A,$00,$9E,$20,$39,$39,$39,$39,$00,$00,$00

 ;now sys 4618:

;  .byte $0C,$08,$0A,$00,$9E,$20,$34,$36,$31,$38,$00,$00,$00
 ;sys 4402; probably need to page align ea table
;  .byte $0C,$08,$0A,$00,$9E,$20,$34,$34,$30,$32,$00,$00,$00


; sys 4630 check fallthrough issue: ; froze immediately, alignment issue where?

; .byte $0C,$08,$0A,$00,$9E,$20,$34,$36,$33,$30,$00,$00,$00

  org $1000  ; sys 4096+256+18+8 (256 bytes Virtualworld and sprites header and C64 specific Tile and Background Tile headers)
  ; org 3840
             ;    + 240
 INCLUDE C64vcs.h

 
;o=$8c

;--- two bytes for music engine, pointer & sustain (score is ROM data block)
MUSICINDEX         = $80                  ; storage location (1st byte in RAM)
SUSTAINFORFRAMES   = $81 ; 129


a = $82 ; 10 bytes for variables, a-j
b = $83 ; note: vars a,b,c,d,e are temp vars so use the stack if you need to preserve them!
c = $84
d = $85
e = $86 ; music engine is using this (it shouldn't) so also a temp var, push to preserve
f = $87
g = $88  
h = $89  
i = $8a  
j = $8b  
;REVBT = $8d
; REVBT var and ReverseB (Reversebyte) routine are not used at all.
;YIndex = $8d ; reusing this location then, will be used to calculate BYTErowoffset as a large virtual world Y value for concept (not necessary)
; Yindex depreciated; BITIndex is direct x position for the virtual world Camera and BYTErowoffset is used to calculate y pos
;(+12 for each y position increment; this is the width of the virtual world, 12 byte row x 8 bits= 96 bits per row [92 addressable, first four are unused])

;PLAYFIELDINDEX = $8e
; just freed variable $8e for reassignment...

;PLAYFIELDINDEXstep = $8f ; 18 bytes for variables so far...
;temp1 = $8f; this temp var mirrors PLAYFIELDINDEXstep for use in your gameloop or anywhere outside of the secondary kernel.
var2 = $8f ; PLAYFIELDINDEXstep var freed - replaced with temp var d in kernel

;reserving another 15 bytes, $90-9F
; --- virtual world variables
BITIndex = $90
BYTErowoffset = $9d ; incs 1 y position in virtual world for each rowsize (12 bytes);goes  with BITIndex (x position)

;20130912 optimisation, freed 3 more vars (now x,y and z)
;p0 = $91
;p1 = $92
;p2 = $93
x =  $BA;PAL FIX 20230118 $A0 CHANGED DYNAMICALLY LIKE $A1 ON NTSC   $A0; $91;tape reserved
y = $92;   $92 reserved for timing constant
z = $93


;-- Scrolling Demo Vars (depreciated)
scrollspeed = $94 ; scrollspeed!
scrollspeedinit = $95; scrollspeed fade... changed to scroll direction (not so intuitive)
;-- End Scrolling Demo vars
;--------------------------- SCROLLOUT Game Vars
px = $96        ; used for game status ( no player x!)
py = $97; player y (there is no player X in Scrollout, it's always on the left)

bx = $98; ball x
by = $99; ball y

bitx = $9a 
bity = $9b
;bitstatus = $9c ; depreciated, don't use
; $9d in use for BYTErowoffset
player0x = $9e
player0y = $9f
;--------------------------- End Scrollout Game Vars

;mirroring some vars:
;(YIndex, scrollspeed,scrollspeedinit,bitstatus) 

t = $8d
u = $94 
v = $95 
w = $9c 

;RAMplayfield deprecated on C64 so using this area for zero page 
; values under contention like x=$91, this is reserved for TAPE
;                          now x= $A0 
RAMplayfield = $A0 ; - DF$
RAMplayfield1 = 170;$A0+10
RAMplayfield2 = 180;$A0+20
RAMplayfield3 = 190;$A0+30
RAMplayfield4 = 200;$A0+40
RAMplayfield5 = 210;$A0+50

; $A1 changes dynamically by system

;Shadow Registers for polling hardware collisions:
;-0--playfield------------------------2-2------------3---4------------
COLUP1 = $A3 ;A1.. shadow register for Atari 2600 Player 1 color
SWCHB = $BB; PAL FIX, CHANGES DYNAMICALLY ON PAL $A2 ; shadow register Atari console switches mapped to F keys
CXP0FB = $A4 ; player 0 playfield collision shadow register
CXCLR = $A5 ; test - OK! ; clear shadow collision registers shadow reg
CXP1FB = $A6 ;player 1 playfield collision shadow register
CXM0FB = $A7; missle 0 playfield collsion shadow register
CXM1FB = $A8; missle 1 playfield collision shadow register
;-0--sprite-collisions------------------------2-2------------3---4------------
CXM0P = $A9  ; d7 d6  mo p1 mo po
CXM1P = $AA  ;d7 d6 m1 po m1 p1
CXPPMM = $AB ; d7 d6  p0p1 m0m1
;-------------------------------------------------------------------shadow regs
NUSIZ0 = $AC
NUSIZ1 = $AD
missile0 = $AE
missile1 = $AF
COLUP0 = $B0 ; deprecated
REFP0 = $B1; dummy use table no bare metal API implemented yet
REFP1 = $B2; dummy use table no bare metal API implemented yet
CTRLPF = $B3
VBLANK = $B4
WSYNC = $B5  
VSYNC = $B6
;o = $ec ; 22 remaining... must leave most of that for the stack ;)
o = $B7
var1 = $B8
score = $b9
reg4voice1 = $c0 ; SID TIA shadow reg (for musicengine API, not bare metal API)
reg4voice2 = $c1 ; SID TIA shadow reg (for musicengine API, not bare metal API)

; [deprecated on C64, repurposed as fast shadow bus regs] using $A0-DF$ (60 bytes) to hold playfield image (20x10 in 40x10 grid)
; Note: half of this screen buffer, 30 bytes, is loaded WYSIWYG from the virtual world buffer (240 bytes),
; then it is expanded 2:1 to 60 bytes and flipped to and fro for the display.
; update: this is now done at once, and now also uses six tables instead of 1 for faster indexing

;2nd display buffer @ $A0-DF$ deprecated; already present as screen buffer:
;20220421 revising pushabstractextendedplayfield 
;Architecture should load the existing screen buffer @c64 screen address
;DLI impelementation; set 10 line consants for the programmable Display Lists 

;C64 Screen quadrants (3 Display Lists in 1st 3, 1 in last quadrant)
;
DisplayList0 = 1064
DisplayList0Shadow = 1104
DisplayList1 = 1304
DisplayList1Shadow = 1344
DisplayList2 = 1544
DisplayList2Shadow = 1584
DisplayList3 = 1784
DisplayList3Shadow = 1824

DisplayList3ShadowColor = 56256 ; 56056+200
DisplayList2ShadowColor = 56200
DisplayList1ShadowColor = 56200-256
DisplayList0ShadowColor = 56200-512



;c64 large tile char graphic - now RAM array @ 4370

Tile1Char = 4370
Tile2Char = 4371
Tile3Char = 4372
Tile4Char = 4373
bTile1Char = 4374
bTile2Char = 4375
bTile3Char = 4376
bTile4Char = 4377


;c64 screen quardrants deprecated versions:
;DisplayListQ1 = 1024
;DisplayListShadowQ1 = 1064
;DisplayListQ2 = 1264
;DisplayListShadowQ2 = 1304
;DisplayListQ3=1504
;DisplayListShadowQ3=1544 
;DisplayListQ4=1744
;DisplayListShadowQ4=1784


player1x = $e0
player1y = $e1 ; 95 bytes of RAM reserved so far; 35 + 60 for the screen buffer

missile0x = $e2
missile0y = $e3

missile1x = $e4
missile1y = $e5

;ball0x = $e6 
;ball0y = $e7

k = $e8
l = $e9
m = $ea
n = $eb ; now 105 bytes of system RAM reserved; 23 remaining
p = $e6 
q = $e7

;Flicker Free mode:
;these next three variables are used to disengage the primary kernel
;whenever the playfield is not scrolling across the virtual world
;: These two have been depreciated, only the toggle is needed
;;checkvirtualx = $ed
;;checkvirtualy = $ef

scrollvirtualworldtoggle = $f0 ; flag variable, could be a bit
r = $ed
s = $ef
; 20220529 this address freezes c64? score = $f1

;!Missed an immediate page fast RAM variable somewhere in low range 0-127, which one?

;---------------Virtual World Bitmap:
virtualworld
ExtendedPlayfieldSCW
REPLACEExtendedPlayfieldSCR
;GameScreenBitmap ; 20x10 grid (3 bytes) is read from a larger play area 5x as wide (12 bytes) and twice as tall
;          1 0      4  2      12   3     20    4    28    5    36     6   44     7   52     8    60     9  68 72* 10   76    11    84   12
;  .byte %00000101 ,%01010101, %01010101, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00001010, %10101010, %10101010, %00000000, %00000110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00001111, %11111111, %11111011, %00000000, %00001111, %00000000, %00000000, %11100111, %11101110, %01110011, %11000000, %00000000
;  .byte %01000000, %00000000, %00101000, %00000000, %00000110, %00000000, %00000000, %10010001, %10001001, %01101001, %11000000, %00000000
;  .byte %00111000, %00000000, %00111000, %00000000, %00000000, %00000000, %00000000, %11110001, %10001111, %01101001, %11000000, %00000000
;  .byte %00101000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %10010001, %10001001, %01111001, %11000000, %00000000
;  .byte %00111000, %00000000, %00001110, %00000000, %00000000, %00000000, %00000000, %10010001, %10001001, %01110001, %11000000, %00000000
;  .byte %00000000, %00000000, %00001010, %00000000, %00000000, %00000000, %00000000, %10010001, %10001001, %01101001, %11000000, %00000000
;  .byte %00000000, %00000000, %00001110, %00000000, %00000000, %00000000, %00000000, %00000000, %10001001, %01100101, %11000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00001000, %00000000, %00000000
;-- next 10 rows is another screen down and 5 across:
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00111000, %00000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00011000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00111100, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %01111111, %00000000, %00011000, %00000000, %00000000, %01111111, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %01010101, %00000000, %00000000, %00000000, %00000000, %01100111, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %01010101, %00000000, %00000000, %00000000, %00000000, %01100111, %00000000, %00000000, %00000000, %00010000
;  .byte %00000000, %00000000, %01111111, %00000000, %00000000, %00000000, %00000000, %01111110, %00000000, %00000000, %00000000, %00101000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00010000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000

;-------------------------------------------------------------
;add padding if pagebreak breaks sprite1
; (sprite RAM (16 bytes) now in bank II)
;-- next 16 bytes used as Sprite RAM (supports vertical flip)
Sprite0SCR
player0
 .byte 0,0,0,0,0,0,0,0
Sprite1SCR
player1
 .byte 0,0,0,0,0,0,0,0 ;--- 256 byte page boundry:

;adding rowcolor playfield support option
;rowcolors .byte 1,2,3,4,5,6,7,8,9,10 ; 
rowcolors .byte replacerowcolors

;check this one... better as default on C64?
player0colors .byte replaceplayer0colors
;player0colors .byte 11,20,30,40,50,60,200,255


;==== Tile Characters and Background Tile Characters are each 4 PETSCII characters/quadrants

;TileCharacters .byte 211,201,202,203;240,241,242,243 Diamond Ring
;TileCharacters .byte 102,102,102,102;240,241,242,243; forecefield I
;TileCharacters .byte 83,83,95,105; Hearts on a Triangle
;TileCharacters .byte 216,216,83,83 ;clubs and hearts
;TileCharacters .byte 83,83,83,83 ; Hearts
;TileCharacters .byte 211,211,83,83 ; Hearts and reverse video hearts
;TileCharacters .byte 211,211,211,83 ; Hearts and reverse video hearts

;TileCharacters .byte 83,83,211,211;,83,83 ; Hearts and reverse video hearts
;TileCharacters .byte 250,250,250,250;solid boxes
;TileCharacters .byte 219,219,219,219 ;grid
;TileCharacters .byte 244,234,244,234 ;near solid columns
;TileCharacters .byte 169,169,169,169 ; fine diagonal pattern (shifted?)
;TileCharacters .BYTE 219,221,215,215 + and o
;TileCharacters .byte 222,1,222,223;,102;32 ; PI design
;TileCharacters .byte 207,208,204,206     ;chipped solid square
;TileCharacters .byte 90,195,195,90 ;gradient
;TileCharacters .byte 46,32,32,46 ;light starfield

;TileCharacters .byte 213,201,202,203; cicle in a quardant box
;TileCharacters .byte 230,208,230,250; boxes with forcefields
;TileCharacters .byte 250,250,250,250; solid tile
;TileCharacters .byte 208,250,208,250 ;Thatch 
;TileCharacters .byte 230,230,230,230; forcefields
;TileCharacters .byte 211,211,211,211; Reverse Video Hearts
;TileCharacters .byte 207,208,32,250 ;big square L
;TileCharacters .byte 209,209,230,250; boxes with forcefields?
;TileCharacters .byte 250,230,230,250; boxes with forcefields diagonal
;TileCharacters .byte 208,208,208,208; BOXES used for BREAKOUT games
;TileCharacters .byte 102,230,102,230; forcefields III
;TileCharacters .byte 209,223,230,233; artifact color petscii
;TileCharacters .byte 209,223,230,166; better artifact color petscii 
;TileCharacters .byte 209,223,230,230; better artifact color petscii II - really cool, used for D3
;TileCharacters .byte 209,230,208,208; Machine design
;TileCharacters .byte 230,230,195,230 ;artifact demo mode example
;TileCharacters .byte 230,195,195,230 ; artifact demo mode example best
;TileCharacters .byte 215,215,215,215  ; outlined boxes
;TileCharacters .byte 238,240,176,174 ;odd
;TileCharacters .byte 238,240,196,197 ;TronDD tile

;TileCharacters .byte 238,240,253,241
;TileCharacters .byte 233,233,233,233 ;diagonals
;TileCharacters .byte 32,32,32,32 ;clear
;TileCharacters .byte 46,46,46,46;102,102,102,102 STARFIELD


;TileCharacters .byte 111,111,111,111 ;parallel even lines

;TileCharacters .byte 46,46,46,46;102,102,102,102 STARFIELD for Ring Raiders
;TileCharacters .byte 207,208,186,250 ;big square

TileCharacters .byte 209,209,230,209; better artifact color petscii


;BackgroundTileCharacters .byte 90,195,195,90;32,32,32,32
;
BackgroundTileCharacters .byte 32,32,32,32;clear
;BackgroundTileCharacters .byte 102,230,102,230; forcefields III
;BackgroundTileCharacters .byte 205,206,206,205; diagonal diamond 
;BackgroundTileCharacters .byte 219,219,219,219 ; thick fence/grid 
;BackgroundTileCharacters .byte 250,250,250,250;solid boxes ARKANOID pattern

;BackgroundTileCharacters .byte 99,100,102,101; cool arkanoid background texture 
;BackgroundTileCharacters .byte 99,100,98,101; cool arkanoid background texture 
;BackgroundTileCharacters .byte 99,100,32,101; cool arkanoid background texture 
;BackgroundTileCharacters .byte 169,169,32,32
;BackgroundTileCharacters .byte 111,111,111,111 ;parallel even lines for Ring Raiders 
;BackgroundTileCharacters .byte 244,234,244,234 ;near solid columns

;BackgroundTileCharacters .byte 121,121,121,121 ;thick parallel even lines 

;BackgroundTileCharacters .byte 102,230,102,230; forcefields III
;BackgroundTileCharacters .byte 77,78,77,78; wavy parallel lines sb AWESOME Fx 
;BackgroundTileCharacters .byte 95,95,95,95;triangles
;BackgroundTileCharacters .byte 169,169,169,169;wavy parallel lines 
;BackgroundTileCharacters .byte 223,223,223,223;diagonal lines
;BackgroundTileCharacters .byte 195,196,198,197 ; arkanoid pattern reverse video
;BackgroundTileCharacters .byte 99,100,101,102; arkanoid paTtern normal v ideo
;BackgroundTileCharacters .byte 99,100,99,100; arkanoid patTern normal v ideo

;BackgroundTileCharacters .byte 208,208,208,208; thick grid

;BackgroundTileCharacters .byte 255,255,255,255; CHESSBOARD THICK
;BackgroundTileCharacters .byte 255,255,211,255; CHESSBOARD THICK rvs Heart

;   102,102,102,102
;BackgroundTileCharacters .byte 46,46,46,46;102,102,102,102
;BackgroundTileCharacters .byte 32,32,32,46; Starfield
;BackgroundTileCharacters .byte 32,32,32,83; Heartfield

;BackgroundTileCharacters .byte 219,219,219,219; rev grid
;BackgroundTileCharacters .byte 123,123,235,242;,102;32
;BackgroundTileCharacters .byte 207,208,186,250 ;big square
;BackgroundTileCharacters .byte 99,100,163,32;,223
;BackgroundTileCharacters .byte 244,234,244,234 ;near solid columns



;------------------SYS 4378
;20220522 trying 240 byte dummy buffer space to prevent code fall through overwrite
;GameScreenBitmap ; 20x10 grid (3 bytes) is read from a larger play area 5x as wide (12 bytes) and twice as tall
dummydatabufffer;          1 0      4  2      12   3     20    4    28    5    36     6   44     7   52     8    60     9  68 72* 10   76    11    84   12
;  .byte %00000101 ,%01010101, %01010101, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00001010, %10101010, %10101010, %00000000, %00000110, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00001111, %11111111, %11111011, %00000000, %00001111, %00000000, %00000000, %11100111, %11101110, %01110011, %11000000, %00000000
;  .byte %01000000, %00000000, %00101000, %00000000, %00000110, %00000000, %00000000, %10010001, %10001001, %01101001, %11000000, %00000000
;  .byte %00111000, %00000000, %00111000, %00000000, %00000000, %00000000, %00000000, %11110001, %10001111, %01101001, %11000000, %00000000
;  .byte %00101000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %10010001, %10001001, %01111001, %11000000, %00000000
;  .byte %00111000, %00000000, %00001110, %00000000, %00000000, %00000000, %00000000, %10010001, %10001001, %01110001, %11000000, %00000000
;  .byte %00000000, %00000000, %00001010, %00000000, %00000000, %00000000, %00000000, %10010001, %10001001, %01101001, %11000000, %00000000
;  .byte %00000000, %00000000, %00001110, %00000000, %00000000, %00000000, %00000000, %00000000, %10001001, %01100101, %11000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00001000, %00000000, %00000000
;-- next 10 rows is another screen down and 5 across:
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00111000, %00000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00011000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %00000000, %00000000, %00111100, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %01111111, %00000000, %00011000, %00000000, %00000000, %01111111, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %01010101, %00000000, %00000000, %00000000, %00000000, %01100111, %00000000, %00000000, %00000000, %00000000
;  .byte %00000000, %00000000, %01010101, %00000000, %00000000, %00000000, %00000000, %01100111, %00000000, %00000000, %00000000, %00010000
;  .byte %00000000, %00000000, %01111111, %00000000, %00000000, %00000000, %00000000, %01111110, %00000000, %00000000, %00000000, %00101000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000, %00010000
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;======================== SYS 4618
;  .byte %00000000, %00000000, %00000000, %00000000, %00000000, %11111111, %00000000, %00000000, %00000000, %00000000, %00000000, %00000000
;======================== SYS 4630
; -- above change froze Defender III immediately so likely stil alignment issue; where?

 ; interrupts causing intermittent freezing? 
 ;20230119 testing pal fix from missing rasterline in NMI trigger...            jsr clearuptheirq
 ;>> Yes fixed issue with freezing on PAL, (rasterline not present?) Thank you Lasse on Lemon64 Commodore forums!
 ; but slow on NTSC
  jsr clearuptheirq ; revised to kickout after 

;-----------------------------------------
 ldx #$FF ;; clear top half of zero page fast RAM
clearimmediatepage sta 0,x
 dex
  cpx #128
 bne clearimmediatepage

  lda  #21 ;REM UPPER CASE/PETSCII MODE
 ;;;; allow user selection sta 53272 


; method to page out the Kernel & BASIC to avoid $92 overwrite
; 2) write #$35 to $01 - from this point, any read of $A000..$BFFFF (normally BASIC ROM) or $D000..$FFFF (normally Kernal ROM) goes to RAM instead.

; lda #$35 ; 001100101   

; sta $01
; Note to get back the Kernal & BASIC , write #$37 to $01

; lda #%00000000  
; sta $00 ; allow $01 to be revised
; sta $01 ; this should be settable now, bit 2 may need to be on for CHAREN signal... testing 20230119 for pal fix

;clear tape io?
;$0334 - $03ff    Tape IO    :

; ldx #$ff
; lda #0
;cleartapeio
; dex
; sta $0334,x
; bne cleartapeio
   

 lda #255
 sta 53271; double height sprites (8 pixels=16 to size to tile height)
 sta 53277; double width

  lda #1
  sta scrollvirtualworldtoggle ; -----init: turns off after Camera view table is refreshed from the virtual world

;clear 1st 4 sprites [player0, player1, missle0,missle1]
;[xpand to get mirror sprites for 2 and 3 doubled feature]

 ldx #255
 lda #0
clearsprites sta 12800,x
 dex
 bne clearsprites

 ;--- sprite 0 and 1 pointer init:
 lda #200
 sta 2040; pointer 
 lda #201
 sta 2041; pointer 
 
 ;--- sprite 2 and 3 (as missile 0 and 1) pointer init:
 lda #202
 sta 2042; pointer 
 lda #203
 sta 2043; pointer 
 


 
 lda #255
 sta CXCLR ; load Atari 2600 shadow collision register Hi (clear latch to clear collisions)


 ;----------------------------------------------
 ;--------pounding $d418? NO only one init, adsr in sound engine does the rest
; now relocated to init section 20230407
; 20221031 ; experiment with turning this off or revising value;
 ;lda   #255;#7
 ; now below...   0 1 1 0 1 1 11  96+15=111
; lda #111;  #127;#127;#31;#127;#95;#31;#15

 ; now below...   0 1 1 0 1 1 01  109 ;20221120 leave bit2 off better without?
 ;lda #109;  #127;#125;#31;#127;#95;#31;#15
 ; statico sound on some games... put bit 2 back on

 ; now below...   0 1 1 1 1 1 1 1  111 ;20221121 leave bit4 on (rich sound) better without?
 ;lda #127;#125;#31;#127;#95;#31;#15
;  LDA #%01111111
;  LDA #%00111111; high pass filter disabled
; lda #%01011111; band pass filter disabled
; lda  #%01101111; low passfilter disabled
 
   LDA #%01111111; low pass band pass and high pass filters on

;  LDA #%01011111; test band pass disabled 20240928

;  LDA #%11111111; test disable v3
 sta $D418;
 lda #255 ;full resonance
 ;lda #%11011111
 sta $d417; full resonance all voices filtered [and external source if present]
 ;turn volume up and activate low pass analog filter Fx@! ;)
 ; (W)	Mode/Vol	Chan 3 Off	High Pass	Band Pass	Low Pass	Volume

;=========================================20230407 mod


  jsr c64init

 ;20230121 BW/COLOR switch now dynamic (shift lock on real hardware)
 ;Shadow register still needs initial state set on init or the CPU JAMS on some programs... not sure why...
  lda #%00001011; configure COLOR,unused,select off,reset off 
 ;lda #%00000011; configure BW switch to BW, select off, reset off 
 sta SWCHB


 
 ;C= Atari 2600 Framework EMU core for C64 [2022 RelationalFramework]

Mainloop
 ;-------------CRT Television Threading Model Architecture:
 
 ;--- poll shadow regs TODO:relocate block here? should be fine below...
  
 jsr GameLoop2; -- The bottom Vertical Blank always runs first! 

;20230814 FrameRelay was out of sequence breaking DefenderIII
;details: DefenderIII uses the Atari Flashback Framework for Abstract Assembly and BASIC programming
; moving FrameRelay between bottom vertical blank and top vertical blank should resolve:


 jsr MusicEngine ; 20220505 Added Music Engine with transparent Fx hook

 ;---- CALL 2ND DISPLAY KERNEL?
 lda scrollvirtualworldtoggle 
 beq skipFrameRelay
 jsr FrameRelay
 ;lda #$1b
 ;sta $d011
skipFrameRelay


 jsr GameLoop; -- Top Vertical Blank (Tip: balance the blanks for more time in your program...)

;20230814 FrameRelay call was previously here out of sequence, see bugfix for Defender III above
 

 ;--- sprites actived?
  ;lda 53269 ; turn off sprite 0 [bit 0] by default to make it invisible:
  ;and  #%11111110  

  lda #0 ; all sprites invisible
  sta 53269
; lda #0 
  sta 53278 ; turn off sprite collisions (passed to shadowr regs)
  sta 53279 ; clear c64 real collision reg/playfield; turn off playfield collisions (passed to  shadow regs)



 ; ---backward compatible: activate sprites if player0y/1y  >0 

  lda player1y
  beq player1done
  jsr renderplayer1
player1done

  lda player0y
  beq player0done
  jsr renderplayer0
player0done


  lda missile1y
  beq missle1done
  jsr rendermissle1
missle1done

  lda missile0y
  beq missle0done
  jsr rendermissle0
missle0done

;relocate clear c64 collision regs prior to call

; --- sprites now in synch for tilemapping instead of 1 behind
;POLL COLLISION/CLEAR REGISTERS AND CXP0FB and CXCLR SHADOW:
; --------------------These two Atari 2600 Shadow registers talk to one other:
 ;20220525 hotfix sys never loads CXCLR setting other shadow regs [CXCLR shadow reg under Atari 2600 Programmer control]
 lda CXCLR 
 bne CXCLRloaded
;==========================================
 lda #0
 sta CXP0FB ; clear the collision flag Atari 2600 Shadow register when Shadow CXCLR is #0
 sta CXP1FB ; player 1 playfield shadow reg
 sta CXM0FB ; missile 0 playfield shaddow reg
 sta CXM1FB ; missile 1 playfield shadow reg
 ;;;; now above  sta 52378 ; clear c64 real collision reg/sprites remove after individual handlers [4]
 sta CXM0P ; d7 m0 p1 d6 m0 p0
 sta CXM1P; d7 m1 p0  d6 m1 p1
 sta CXPPMM; clear player0 player1 collision
 ;;;; now above sta 53279 ; clear c64 real collision reg/playfield
  lda #255
 sta CXCLR ; reset the Shadow Register Collision latch
 ;;; 20220522 this jmp was crashing defendier III! 
 JMP continuex
 ; no it wasnt... it's needed or emu can get stuck in a loop

CXCLRloaded
 ;lda #0
 ;freeze immediately sta CXCLR ; force reset every other frame should resolve sticky collisions
;;; jmp continue  ; 
;==========================================
;-------------------- C64 sprite playfield collision register load Shadow reg:
;==========================================
;$D01E
;53278	
;Sprite-sprite collision register. Read bits:
;Bit #x: 1 = Sprite #x collided with another sprite.
;Write: Enable further detection of sprite-sprite collisions.
;$D01F
;53279	
;==========================================
;Sprite-background collision register. Read bits:
 lda 53279 ; 
 ;; opt superflous now: tay
 ror; check bit 0 for sprite 0 playfield collision
 bcc No_CSMACD_Playfield_Collisions
;; lda #0
;; sta CXCLR
 ldX #130
 stX CXP0FB
 ;lda 53279
 ;and #%11111110 ; turn off sprite 0 playfield collision bit on real C64 reg 
 ;sta 53279
 ;20220530 OPT TO FIX MISSING THE SHADOW HANDLERS SET THEM ALL:
 ;jmp continuex; doneplayercollisions
No_CSMACD_Playfield_Collisions
 ;20220525 opt accumulator already loaded and rolled once
 ;tya; repeat for next sprite 2 of 4
 ;ror; check bit 0 for sprite 0 playfield collision
 ror

 bcc No_CSMACD_Playfield_Collisions1
 ;;lda #0
 ;;sta CXCLR
 ldX #130
 stX CXP1FB
 ;lda 53279
 ;and #%11111101 ; turn off sprite 1 playfield collision bit on real C64 reg 
 ;sta 53279
 
 ;20220530 OPT TO FIX MISSING THE SHADOW HANDLERS SET THEM ALL:
 ; jmp continuex; doneplayercollisions
No_CSMACD_Playfield_Collisions1
;=============================================================
;Bit #x: 1 = Sprite #x collided with background.
;Write: Enable further detection of sprite-background collisions.
;lda 
;==========================================

;=============================================================
;now repeat for both missle sprites playfield collision, what are their shadow regs?:
;CXM0FB and CXM1FB
;=============================================================
;==========================================
;Sprite-background collision register. Read bits:
 ;;lda 53279 ; 

;;20220525 opt, y already loaded and rolled 2x; confirm with test program...
;; tay
;; ror; check bit 2 for missile0 (sprite 2) playfield collision
;; ror
 ror
 bcc No_CSMACD_Playfield_Collisionsm
 ;;lda #0
 ;;sta CXCLR
 ldx #255
 stx CXM0FB ; load 
 ;lda 53279
 ;and #%11111011 ; turn off sprite 2 (missle 0) playfield collision bit on real C64 reg 
 ;sta 53279
 ;20220530 OPT TO FIX MISSING THE SHADOW HANDLERS SET THEM ALL:
 ; jmp continuex; doneplayercollisions

No_CSMACD_Playfield_Collisionsm

;20220525 opt accumulator already loaded and rolled 3x
; tya; repeat for next sprite 2 of 4
; ror; check bit 3 for missle 1 playfield collision
; ror
; ror
 ror

 bcc No_CSMACD_Playfield_Collisions1m
 ;;lda #0
 ;;sta CXCLR
 ldx #255
 stx CXM1FB
; lda 53279
; and #%11110111 ; turn off sprite 0 playfield collision bit on real C64 reg 
; sta 53279; 20220520 fix
  ;20220530 OPT TO FIX MISSING THE SHADOW HANDLERS SET THEM ALL:
 ; jmp continuex; doneplayercollisions
No_CSMACD_Playfield_Collisions1m
;=============================================================

;=============================================================
; now repeat for sprite sprite and sprite missle collissions, what are their shadowregs?
;=============================================================
 lda 53278 ; c64 real sprite -sprite/missile collision regissters
 tay         ; Bit #x: 1 = Sprite #x collided with another sprite.
 ; player 0 collision: player 1 or missile 0 or 1?
 ror
 bcc noplayer0collisions
 ;lda 53278
 ;and #%11111110 ; turn off collision bit on real C64 reg 
 ;sta 53278
 
 ;20220525 opt acculumlator already loaded and rolled once
 ;tya ; ---- Player0 colided and bit is back off, now find WHAT player 0 colided with:
 ;ror
 ror; player1 collission with player0?
 bcc noplayer0player1collision 
 ldx #128; set bit 7
 stx CXPPMM 
;; lda #0
 ;;sta CXCLR; set shadow register
; lda 53278
; and #%11111101 ; turn off sprite 1 SPRITE collision bit on real C64 reg 
; sta 53278
 jmp continuex; 20220525 load balancing jmp doneplayercollisions
noplayer0player1collision ; missle 0 or 1 collision?
;20220525 opt accumulator already loaded and rolled twice
; tya
; ror
; ror
 ror
 bcc noplayer0missile0collision
 ;set CXM0P bit 6 PO MO
 ldx #%01000000
 stx CXM0P
;; lda #0
 ;;sta CXCLR; set shadow register
; lda 53278
; and #%11111011 ; turn off sprite 2 (missle 0) SPRITE collision bit on real C64 reg 
; sta 53278
 
;20220530 opt fall through: jmp continuex; 20220525 loadbalancing jmp doneplayercollisions 
noplayer0missile0collision
;20220525 opt accumulator already loaded and rolled 3x
; tya
; ror
; ror
; ror
 ror
 bcc noplayer0missile1collision
 ; set CXM1P bit 7 po m1
 ldx #%10000000
 stx CXM1P
;; lda #0
 ;;sta CXCLR; set shadow register
 ;lda 53278
 ;and #%11110111 ; turn off sprite 3 (missle 1) SPRITE collision bit on real C64 reg 
 ;sta 53278

; 20220530 opt fall through: jmp continuex
noplayer0missile1collision
;;;;;; jmp continuex; doneplayercollisions; should never get here (not using other 4 bits/sprites)
noplayer0collisions

;----------20220520 *** ONLY PLAYER1 M1 OR PLAYER1 M0 REMAINING:
 ; player 1 collision; missle 0 or 1? (already checked player 0 player1)
 tya
 ror
 ror
 bcc  checkmissilecollisions ; NO PLAYER1 COLLISIONS [load balanced: when branch is unloaded defines missile and player sizes if no other collisions including missle collisions]
 ror
 bcc noplayer1missile0collision
 ; set CXM0P D7 P1 M0
 ldx #%10000000
 stx CXM0P
;; lda #0
 ;;sta CXCLR; set shadow register
; lda 53278
; and #%11111001 ; turn off sprite 1 (player1) and sprite 2 (missle 0) SPRITE collision bit on real C64 reg 
; sta 53278
 ; 2020530 opt fall through: jmp continuex;doneplayercollisions
noplayer1missile0collision 
 ror; fetch next bit, cursor already at bit 2
 bcc checkmissilecollisions; continuex; 20220525 opt doneplayercollisions
 ;set CXM1P d6 p1 m1
 ldx #%01000000
 stx CXM1P
;; lda #0
;; sta CXCLR; set shadow register
 ;lda 53278
 ;and #%11110101 ; turn off sprite 1 (player1) and sprite 3 (missle 1) SPRITE collision bit on real C64 reg 
 ;sta 53278
 ;;;; 20220525 opts hit this line, need to fall through if no load to set missilesizes: jmp continuex

;20220525 adding Missile 0 and Missile 1 collision detection [missing after opt]
 jmp continuex 
checkmissilecollisions
 ror
 bcc  doneplayercollisions; 20220525 opt [only set missile and sprite size shadow regs when branch is unloaded]
 ror
 bcc doneplayercollisions
 ldx #%01000000
 stx CXPPMM; set shadow register
;; lda #0
 ;;sta CXCLR; set shadow register

 jmp continuex ; leave last opt so heaviest branch skips NUSIZO

; fall through if no collisions to set missile and sprite sizes and  replication from shadow regs:

doneplayercollisions
 ;------------------------------

 ;-------define player and sprite sizes from shadow regs [load balanced only runs if no collisions]
 lda NUSIZ0
 and #%00110000
 cmp #%00110000
 beq widerNUSIZ0
 lda #%00011000
 sta missile0
 bne donenusiz0
widerNUSIZ0
 lda #%11111111
 sta missile0
donenusiz0


 lda NUSIZ1
 and #%00110000
 cmp #%00110000
 beq widerNUSIZ1
 lda #%00011000
 sta missile1
 bne donenusiz1
widerNUSIZ1
 lda #%11111111
 sta missile1
donenusiz1

 ;SUPERFLUOUS COLBUK IS DIRECTLY MAPPED TO BGCOLOR $D021 (53281)
 ;LDA COLUBK
 ;STA $D021; SET BACKGROUND COLOR FROM SHADOW
  
;==============================================================
 
 ; 

 ;inc $D021 ;screen background register
 ;linc $ff ; inc zero page FF
 ;bne continue
 ;inc $D020 ;screen border register
continue:
continuex

;20231104 testing blank screen -- this needs to go in framerelay where pushextendedplayfield is called for STARBLITZ 30 Hz Fx 20231105
;see framerelay


;NTSC find the next frame:
nextframe lda   #254; NTSC or PAL 
;nextframe lda #0; doublespeed option for NTSC or PAL (comment line above) 
;nextframe lda #14;#$37;#14;PAL option
    cmp $d012
    bcs nextframe

  
;---- bw switch 20230120
;SCAN FOR SHIFT LOCK KEY AS BW/COLOR SWITCH
 lda #128;#2; #255
 STA 56320
 LDA 56321
; LDA  653
; CMP #15
 rol
 bcC nobwset

 ;beq nobwset
  lda #%00001011; configure COLOR,unused,select off,reset off 
  bne bwdone
nobwset
 lda #%00000011; configure BW switch to BW, select off, reset off 
bwdone
   sta SWCHB
;--- end dynmic bw switch


 jmp Mainloop ;-------------REPEAT-MAIN-LOOP------------
 ; assemble with Dasm syntax: dasm Colorflash.asm -oColorflash.prg
 ;----------------------------------------------------------------



;-------------------------------------------------------------
FrameRelay ;--------------- blank frame calculation space/time
;-------------------------------------------------------------
 ; Call primary rending engine to load playfield CAM view:

 ;20220525 preserve background color
      ;20220924 COLUPF shadow reg = textcolorreg 646
; lda 646 ; PRESERVE TEXT/PLAYFIELD COLOR
; pha
 LDA $D021 ; PRESERVE BACKGROUND COLOR
 ;PHA

 ;sta $d011 ; turn off screen to shape custom video signal from 60 Hz signal (putput 30 Hz, 20 Hz, etc)
  ; 20220529 the background color, usually Black, should replace everything during blank frame
  ; lda #0 
 sta $d020
; redundant sta $d021
 ;sta 646 ; can't do that... need to update color RAM 
  
   lda #0
   sta scrollvirtualworldtoggle; turn toggle back off (0 GETS WHOLE SCREEN, ALL 10 ROWS NOT A SECTION)

   ;20231105 Adding black screen illegal VIC-II mode for STARBLITZ 30 Hz filter! (uncomment next 6 lines and the 4 lines in section below)
   ; 20231119 keeping this commented, can uncomment both section55s for MBR Motion Blur Reduction Filter
   ; probably only need to change $d011, $d016 is already configured [using text mode]
   ;confirmed, next 3 lines and two lines in section below turn MBR filter on and off (already in text mode, other bit is preconfigured)

;------------------------------------------------------------------------------------------------------------------------------------
;; -- MBR Filter Section 1, Motion Blur Reduction is deactivated if these 3 lines are commented and the 2 lines in section II below:
;------------------------------------------------------------------------------------------------------------------------------------

  ; lda $d011 ; --- mbr filter off if commented
  ; and #%01000000 ;activate ECM bit 6 ; --- mbr filter off if commented
  ; sta $d011 ; --- mbr filter off if commented

;; unneeded code:
;; -- superflous, bit already set       lda $d016
;; -- superflous, bit already set       and #%00010000 ;activte MCM bit 4, now black screen!
;; -- superflous, bit already set       sta $d016

   ; ---- time intensive calls go here!
replacekitchensinkcode
 
   jsr pushabstractextendedplayfield

   lda #0 ; why is it getting set there? should come back off...
   sta scrollvirtualworldtoggle; turn toggle back off (0 GETS WHOLE SCREEN, ALL 10 ROWS NOT A SECTION)

 

 ; --- wait to turn it back on:

 ; using #0 will overclock emu x2 in the first nextframe label (not here, search above) 


nextframe2   lda  #254;#0; #254; 20220921 opt #250
   cmp $d012
    bcs nextframe2

;20231105 blank screen 30 Hz filter turn screen back on (uncomment next 2 lines and 3 lines above for MBR filter) 
;-----------------------------------------------------------------------------------------------------------------
; MBR (motion blur reduction) Filter Section II:
   lda #$1b ; --- mbr filter is off if section I is commented (see block above to uncomment) 
   sta $d011; --- mbr filter is off if section I is commented (see block above to uncomment)
;-------------------------------end MBR filter section II

;-----------------------------------------------------------------------
 ;-- 20240113 Color RAM AI update routine:
 ;-- update color rows only if they have changed 
 ;-----------------------------------------------------------------------
  ;  jmp endcolorramupdate ;  timing option; not always enough free cycles for playfield colors
  ;--- note set this to jmp if program freezes, likely not enough time
  ; (load balance opt - should only allow one or two color row per frame to resolve; queue it)


  lda rowcolors+9; get 10th row (after 9th)
  ;compare to top row
  cmp 55336
  beq colorrow10done
  ldx #79
colorrow10 sta 55336,x
  dex 
  bne colorrow10
  sta 55336,x; color last character in row
colorrow10done



  lda rowcolors+8; get 1st row
  ;compare to top row
  cmp 56056 
  beq colorrow1done
  ldx #79
colorrow1 sta 56056,x
  dex 
  bne colorrow1
  sta 56056,x; color last character in row
colorrow1done


  lda rowcolors; get 2nd row
  ;compare to top row
  cmp 55416
  beq colorrow2done
  ldx #79
colorrow2 sta 55416,x
  dex 
  bne colorrow2
  sta 55416,x; color last character in row
colorrow2done


  lda rowcolors+1; get 3rd row
  ;compare to top row
  cmp 55496
  beq colorrow3done
  ldx #79
colorrow3 sta 55496,x
  dex 
  bne colorrow3
  sta 55496,x; color last character in row
colorrow3done



  lda rowcolors+2; get 4th row
  ;compare to top row
  cmp 55576
  beq colorrow4done
  ldx #79
colorrow4 sta 55576,x
  dex 
  bne colorrow4
  sta 55576,x; color last character in row
colorrow4done

  lda rowcolors+3; get 5th row
  ;compare to top row
  cmp 55656
  beq colorrow5done
  ldx #79
colorrow5 sta 55656,x
  dex 
  bne colorrow5
  sta 55656,x; color last character in row
colorrow5done


  lda rowcolors+4; get 6th row
  ;compare to top row
  cmp 55736
  beq colorrow6done
  ldx #79
colorrow6 sta 55736,x
  dex 
  bne colorrow6
  sta 55736,x; color last character in row
colorrow6done

  lda rowcolors+5; get 7th row
  ;compare to top row
  cmp 55816
  beq colorrow7done
  ldx #79
colorrow7 sta 55816,x
  dex 
  bne colorrow7
  sta 55816,x; color last character in row
colorrow7done

  lda rowcolors+6; get 8th row
  ;compare to top row
  cmp 55896
  beq colorrow8done
  ldx #79
colorrow8 sta 55896,x
  dex 
  bne colorrow8
  sta 55896,x; color last character in row
colorrow8done


  lda rowcolors+7; get 9th row
  ;compare to top row
  cmp 55976
  beq colorrow9done
  ldx #79
colorrow9 sta 55976,x
  dex 
  bne colorrow9
  sta 55976,x; color last character in row
colorrow9done




endcolorramupdate


 ;-----------------------------------------------------------------------
 ; --- end Color RAM AI update
 ;-----------------------------------------------------------------------
 ;-----------------------------------------------------------------------


;; -- superflous, bit already set    lda #8
;; -- superflous, bit already set        sta $d016
;; -- superflous, bit already set        end turn screen back on

;20220921 opt comment 3 lines free 2% timing loop


  ;turn screen back on
 ;redundant:
 ; lda #14 
 ;PLA
  ;sta $d021 ;BACKGROUND COLOR COLUBK
  ;;?SUPERFLUOUS 20220924 lda #10 
 ;sta ;$d020 ; border
;; pla ;lda #10
 
  ;;sta 646 ;text color COLUPF [PETSCII PLAYFIELD]


 rts
 
 ;---------------------end FrameRelay



 ;--routines and sprite graphic library:
  ;-------------------------------------------------------------------
fastmultiply;15 byte routine courtesy of David Holz, codebase64 wiki
 lda #$00
  beq enterLoop
doAdd:
   clc
    adc a;num1

loop:
     asl a;num1
enterLoop: ;For an accumulating multiply (.A = .A + num1*num2), set up num1 and num2, then enter here
      lsr b;num2
       bcs doAdd
        bne loop
        rts ;result is in accumulator
;-------------------------------------------------------------------
; 8bit/8bit division
; David Holz)
;
; Input: num, denom in zeropage
; Output: num = quotient, .A = remainder
fastdivide
 lda #$00
 ldx #$07
 clc
divroll;:
  rol a;num
  rol
  cmp b;denom
  bcc divdex;:+
   sbc b;denom
divdex;:
 dex
 bpl divroll;:--
 rol a;num  - quotient in a, % in accumulator
 rts
; 19 bytes
;
;  Best case  = 154 cycles
;  Worst case = 170 cycles
;
; With immediate denom:
;  Best case  = 146 cycles 
;  Worst case = 162 cycles
;
; Unrolled with variable denom:
;  Best case  = 106 cycles
;  Worst case = 127 cycles
;
; Unrolled with immediate denom:
;  Best case  =  98 cycles
;  Worst case = 111 cycles
;--------------------------------------end fast divide

;--------------------------------------------------------
;--WYSIWYG inline Sprite Library (vertical flip supported!) 
;---16 images (128 bytes) can be expanded up to 32
;---(can be relocated to bank 3 with no changes to free up space here)
;--------------------------------------------------------
; jsr loadplayer0, loadplayer1, y reg holds the index argument
; (set y to 0/8/16/24/etc to load image 1/2/3/4/etc) 
; (target image is loaded upside down into high RAM)
; vertical flip functions added: jsr loadplayer0upsidedown, loadplayer1upsidedown, y reg holds the index argument
; (hardware already provides support for horizontal flip)
;-------------------------------------

-------------------------------------
pushabstractextendedplayfield  ;------
Lpushabstractextendedplayfield
LDLI; Display List Interrupt Routine for vwBASIC
;-------------------------------------
; BITIndex - determines how far to shift in to pull the 3 byte row:
; p0, p1, p2 - variables to hold the 3 byte row
; 20130912 optimisation for memory, freeing 3 vars:
; (replacing p0,p1,p2 with temp vars a,b,d)

;20220421 C64 revision to load bits into screen RAM buffer as doubled bytes not as doubled bits into low RAM buffer 


;---- 20131128 REVISE THIS FOR 8 HANDLERS INSTEAD OF 12:
;revision....
 ldx BITIndex
; inx
; inx
; inx
; inx ; push it up 4, that's where it really is now we need 8 handlers instead of 12
 ;add to row offset

 lda #0
 sta b; byte offset to start at

 txa
opt32 cmp #24
 bcc doneopt32
 inc b
 inc b
 inc b
 sec
 sbc #24
 jmp opt32
doneopt32

getindexoffset cmp #8
 bcc doneindexoffset
 inc b
 sec
 sbc #8
 jmp getindexoffset
doneindexoffset
 sta a ; bit offset position in

 ;now add byte offset down
 lda BYTErowoffset
 clc
 adc b ; add bytes down (already 12 per row) and amount of bytes in
 sta b; 20160425
 ldy scrollvirtualworldtoggle  ; --- current displaylist (1=all or 2 or 3 rows)
 bne getspecifiedrows
 ;sta b
 sty c 
 ;lda #0 
 ;sta c
 lda #10
 sta scrollvirtualworldtoggle      ; load all 10 rows if 1[on] specified
 jmp shiftandtransposephatpixels


getspecifiedrows    ;----- 20160311 60 hz at 30 fps multiple animation bands enhancement - How many rows should be animated, and where should they start? :)

;20160425 revising for display list interrupts (always 2 rows wide)


;30270425 use 3 prefix as flag to expand to 3 rows wide
 cpy #30 
 bcc dontgetthree
 tya
 sec
 sbc #29
 tay
 dey 

 sta scrollvirtualworldtoggle ; get 3 rows instead of 2 *may not have time for all sprites 


dontgetthree
 lda fastyindex,y; seeded from scrollvirtualworldtoggle*fix it for undocumented pass
 clc
 ;adc #96 ; grab last two rows only?
 adc b
 sta b ; byte offset to start at
 ;sty scrollvirtualworldtoggle - already there
 
 ; if xreg flagged dey or inc svwt to grab 3 rows instead of one
 sty c
 inc scrollvirtualworldtoggle
 inc scrollvirtualworldtoggle


 ;lda #8 ; checking... time for 3 rows

; sta c ; dec 9 to 0, 10 steps to build 10 rows

shiftandtransposephatpixels 
 lda b ; preserve
 pha
 lda a
 pha

 ldy b; #!

; lda a
; bne posnot0
;pos0  ;----------------------------------
 ;-- no shifting required, just transpose
 ;-- (shift and) call transposer (reuse transposer!)
 ldx c
 
 lda ExtendedPlayfieldSCR,y+3 ; 4th byte holds a bit we need
 sta c ; store the 4th byte with that extra bit in c
 lda ExtendedPlayfieldSCR,y
 sta a;p0
 lda ExtendedPlayfieldSCR,y+1
 sta b;p1
 lda ExtendedPlayfieldSCR,y+2
 sta d;p2

 pla
 bne notbp0
 jmp transposenext ; bitpos0
notbp0
 rol c
 rol d;p2
 rol b;p1
 rol a;p0

 cmp #1
 bne notbp1
 jmp transposenext;bitpos1
notbp1

 rol c
 rol d;p2
 rol b;p1
 rol a;p0
 cmp #2
 bne notbp2
 jmp transposenext
notbp2

 rol c
 rol d;p2
 rol b;p1
 rol a;p0
 cmp #3
 bne notbp3
 jmp transposenext
notbp3

 rol c
 rol d;p2
 rol b;p1
 rol a;p0
 cmp #4
 bne notbp4
 jmp transposenext
notbp4

 rol c
 rol d;p2
 rol b;p1
 rol a;p0
 cmp #5
 bne notbp5
 jmp transposenext
notbp5
 rol c
 rol d;p2
 rol b;p1
 rol a;p0
 cmp #6
 bne notbp6
 jmp transposenext
notbp6
 rol c
 rol d;p2
 rol b;p1
 rol a;p0

 ;pla
; stx c
; jsr transposer
; jmp transposenext
 ;fall through to transpose next if bitpos7 ;----------------------

transposenext
 pha
 stx c ; restore c
 jsr transposer

 pla ; restore a & b temp vars used to loop and point (Bit and Byte offsets)
 sta a
 pla
 sta b


 lda b
 clc
 adc #12
 sta b ; advance down one row relative to position
 inc c

; lda #10 ;debug first row only
; sta c ; debug

 lda c
 cmp scrollvirtualworldtoggle;#10 20160311 py is #10 if it comes in at zero (scrollvirtualworldtoggle full screen update) otherwise partial
 beq donegoback
 jmp shiftandtransposephatpixels; if we have another row to grab
donegoback
 rts
;------------------------------------------------------------------------
;------------------------------------------------------------------------
transposer   ;----called in line rowbyrow from pushabstractextendedplayfield-replaces abstract playfield builder!

;--20220424 C64 Implementation, replacing bit buffers with C64 text screen character tiles

;--20160525 index optimization, replacing 6x10 display buffer with six 1x10 buffers (shared index)
;; -- not going to need this, c will be a direct index (and only 1 inc later):
;; -- won't need to push and pull the y index (c) since it is being used directly also...
;; $A0, $A0+10, ... $A0+50 replaces $A0

;; lda c
;; pha ; need cx3 ... ; why pushing this?
;; lda #0
;; ldy c
;;cx3 cpy #0
;; beq donecx3
;; clc
;; adc #6
;; dey
;; jmp cx3
;;donecx3
;; sta c


;----------------------------------------------
;--- 20220424 c64 version y now counts 1k screen quadrant--
;----------------------------------------------
;Tile4Char = #171
;DisplayListQ1 = 1024
;DisplayList0ShadowQ1 = 1064
;----------------------------------------------

 ; DISPLAY LIST ROWS (10) Engine mapping to C64 Screen Quardrants (4)

 lda c;ROW HANDLER, USE ROW BASED ADDRESS NOT QUADRANT BASED (NEED 10 NOT 4)

 bne  notrow0
 ldy #0
 jmp rowsQ1
notrow0 

 cmp #1
 bne notrow1

 ldy #80
 jmp rowsQ1
notrow1


 cmp #2
 bne notrow2
 ldy #160
 jmp rowsQ1
notrow2


 cmp #3
 bne notrow3
 ldy #0
 jmp rowsQ2
notrow3

 cmp #4
 bne notrow4
 ldy #80
 jmp rowsQ2
notrow4

 cmp #5
 bne notrow5
 ldy #160
 jmp rowsQ2
notrow5

 cmp #6
 bne notrow6
 ldy #0
 jmp rowsQ3
notrow6

 cmp #7
 bne notrow7
 ldy #80
 jmp rowsQ3
notrow7


 cmp #8
 bne notrow8
 ldy #160
 jmp rowsQ3
notrow8

 cmp #9
 bne notrow9
 ldy #0
 jmp rowsQ4
notrow9

 rts
 ;-------------------------------------------
 ;debug code left over from building is never reached:
 ; 64 is spacious with endless RAM going on forever... like bitd
 ldx #0

screendebug
 txa 
; lda #255
 sta 1544,x
 inx
 cpx #255
 bne screendebug
 rts ; no other row handlers yet...
;-------------------------------------------
rowsQ1; c is 0,80,or 160 for tile rows 1,2,3
 ;ldy #0;always 0 at start of row 0, 80 at start of row 1
 ldx a
 ;  2 bits of first byte build 4 bits of pf0 target byte in memory
 ; next two bits of it build the first 4 bits of pf1,
;--
 txa
 and #%00001000 ; keep 1st bit (1/2 byte)
; is the 1st bit set?    
 beq skip01

 lda Tile1Char
 sta DisplayList0,y
 lda Tile3Char
 sta DisplayList0Shadow,y
 
 lda Tile2Char
 sta DisplayList0,y+1
 lda Tile4Char
 sta DisplayList0Shadow,y+1

;rem next 3
; tya
; ora #%00110000  ;set two playfield bits for 1 in pfo btye
; tay ; put it in y
 jmp skip01background

skip01
 lda bTile1Char
 sta DisplayList0,y
 lda bTile3Char
 sta DisplayList0Shadow,y
 
 lda bTile2Char
 sta DisplayList0,y+1
 lda bTile4Char
 sta DisplayList0Shadow,y+1
skip01background

 txa
 and #%00000100 ; keep 2nd bit           (half byte)
; is the 2nd bit set?
 beq skip02

 lda Tile1Char
 sta DisplayList0,y+2
 lda Tile3Char
 sta DisplayList0Shadow,y+2
 ;iny
 lda Tile2Char
 sta DisplayList0,y+3
 lda Tile4Char
 sta DisplayList0Shadow,y+3
 ;iny
; tya
; ora #%11000000 ; set next two playfield bits for 1 in pf0 byte
; tay
 jmp skip02background
skip02
 lda bTile1Char
 sta DisplayList0,y+2
 lda bTile3Char
 sta DisplayList0Shadow,y+2 
 lda bTile2Char
 sta DisplayList0,y+3
 lda bTile4Char
 sta DisplayList0Shadow,y+3
skip02background

;-- write phat pf0:
;; txa ; preserve X in A
;; ldx c
 ;;sty $A0,x ; c write offset will be 60 when b read offset is 30
;; tax ; restore X
;-- remember to subtract 5 from c before rts!

;;20160525 inc c ; on to next playfield byte target, pf1
; next two bits of read b go into the next c


; ldy #0 ; clear target 
 
 txa ;x still has 1st byte from abstract ROM playfield
 and #%00000010 ; keep 3rd bit
 beq skip03

; tya
; ora #%00110000 ; set two bits for 1 in pf1 target byte
; tay

 lda Tile1Char
 sta DisplayList0,y+4
 lda Tile3Char
 sta DisplayList0Shadow,y+4
; iny
 lda Tile2Char
 sta DisplayList0,y+5
 lda Tile4Char
 sta DisplayList0Shadow,y+5
; iny

 jmp skip03background 
skip03
 lda bTile1Char
 sta DisplayList0,y+4
 lda bTile3Char
 sta DisplayList0Shadow,y+4 
 lda bTile2Char
 sta DisplayList0,y+5
 lda bTile4Char
 sta DisplayList0Shadow,y+5
skip03background

 txa ; get our byte back
 and #%00000001 ; keep 4th bit
 beq skip04
; tya
; ora #%11000000 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList0,y+6
 lda Tile3Char
 sta DisplayList0Shadow,y+6
; iny
 lda Tile2Char
 sta DisplayList0,y+7
 lda Tile4Char
 sta DisplayList0Shadow,y+7
 ;iny
 jmp skip04background

skip04
 lda bTile1Char
 sta DisplayList0,y+6
 lda bTile3Char
 sta DisplayList0Shadow,y+6 
 lda bTile2Char
 sta DisplayList0,y+7
 lda bTile4Char
 sta DisplayList0Shadow,y+7
skip04background

; ------- TRANSFORM 2nd of 3 source BYTES in the row
; inc b ; get 2nd byte
; tya ; preserve y
; ldy b
 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx b;   $a0+#30,y ; ... from the RAM page it was dropped off at!
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
 and #%10000000 ; first bit set?
 beq skip05

; tya
; ora #%00001100 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList0,y+8
 lda Tile3Char
 sta DisplayList0Shadow,y+8
; iny
 lda Tile2Char
 sta DisplayList0,y+9
 lda Tile4Char
 sta DisplayList0Shadow,y+9
; iny
 jmp skip05background

skip05
 lda bTile1Char
 sta DisplayList0,y+8
 lda bTile3Char
 sta DisplayList0Shadow,y+8 
 lda bTile2Char
 sta DisplayList0,y+9
 lda bTile4Char
 sta DisplayList0Shadow,y+9
skip05background

 txa
 and #%01000000 ; check 2nd bit set
 beq skip06
; tya
; ora #%00000011 ; set two bits for 1 in pf1 target byte - DONE with PF1
; tay              ;* 20120801 this WAS the location of the col5 bug 00001111!
 lda Tile1Char
 sta DisplayList0,y+10
 lda Tile3Char
 sta DisplayList0Shadow,y+10
; iny
 lda Tile2Char
 sta DisplayList0,y+11
 lda Tile4Char
 sta DisplayList0Shadow,y+11
 ;iny
  jmp skip06background

skip06
 lda bTile1Char
 sta DisplayList0,y+10
 lda bTile3Char
 sta DisplayList0Shadow,y+10 
 lda bTile2Char
 sta DisplayList0,y+11
 lda bTile4Char
 sta DisplayList0Shadow,y+11
skip06background

; txa ; preserve X in A
; ldx c
; already in c64 screen buffer, sty $A0+10,x ; c write offset will be 60 when b read offset is 30
; tax

;; 20160525 inc c ; on to next playfield byte target, pf2
;; ldy #0 ; clear target for 3rd byte write
 txa
 and #%00100000 ; check 3rd bit set
 beq skip07
; tya
; ora #%00000011; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList0,y+12
 lda Tile3Char
 sta DisplayList0Shadow,y+12
; iny
 lda Tile2Char
 sta DisplayList0,y+13
 lda Tile4Char
 sta DisplayList0Shadow,y+13
 ;iny
 jmp skip07background
skip07
 lda bTile1Char
 sta DisplayList0,y+12
 lda bTile3Char
 sta DisplayList0Shadow,y+12 
 lda bTile2Char
 sta DisplayList0,y+13
 lda bTile4Char
 sta DisplayList0Shadow,y+13
skip07background

 txa
 and #%00010000 ; check 4th bit set
 beq skip08
; tya
; ora #%00001100; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList0,y+14
 lda Tile3Char
 sta DisplayList0Shadow,y+14
; iny
 lda Tile2Char
 sta DisplayList0,y+15
 lda Tile4Char
 sta DisplayList0Shadow,y+15
; iny

 jmp skip08background

skip08
 lda bTile1Char
 sta DisplayList0,y+14
 lda bTile3Char
 sta DisplayList0Shadow,y+14 
 lda bTile2Char
 sta DisplayList0,y+15
 lda bTile4Char
 sta DisplayList0Shadow,y+15
skip08background


 txa
 and #%00001000; check 5th bit set
 beq skip09
; tya
; ora #%00110000; set two bits for 1 in pf2 target byte
; tay

 lda Tile1Char
 sta DisplayList0,y+16
 lda Tile3Char
 sta DisplayList0Shadow,y+16
 ;iny
 lda Tile2Char
 sta DisplayList0,y+17
 lda Tile4Char
 sta DisplayList0Shadow,y+17
; iny
 jmp skip09background

skip09
 lda bTile1Char
 sta DisplayList0,y+16
 lda bTile3Char
 sta DisplayList0Shadow,y+16 
 lda bTile2Char
 sta DisplayList0,y+17
 lda bTile4Char
 sta DisplayList0Shadow,y+17
skip09background


 
 txa
 and #%00000100; 6th bit set?
 beq skip010


; tya
; ora #%11000000; set lasttwo bits for 1 in pf2 target byte
 ;tay
 lda Tile1Char
 sta DisplayList0,y+18
 lda Tile3Char
 sta DisplayList0Shadow,y+18
; iny
 lda Tile2Char
 sta DisplayList0,y+19
 lda Tile4Char
 sta DisplayList0Shadow,y+19
 ;iny

 jmp skip010background
 
skip010
 lda bTile1Char
 sta DisplayList0,y+18
 lda bTile3Char
 sta DisplayList0Shadow,y+18 
 lda bTile2Char
 sta DisplayList0,y+19
 lda bTile4Char
 sta DisplayList0Shadow,y+19
skip010background

;-- on to next target byte pf0(2):
 txa ; preserve X in A
; ldx c
; sty $A0+20,x ; 3rd byte in row; c write offset will be 60 when b read offset is 30
 tax
;--
;; 20160525 inc c ; on to next playfield byte target, pf0(2)
; ldy #0 ; clear target

 ;20160315 txa ; superfluous here ;)
 
 and #%00000010; 7th bit set? (2nd bit, had to reverse...)
 beq skip011
; tya
; ora #%00110000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+20
 lda Tile3Char
 sta DisplayList0Shadow,y+20
; iny
 lda Tile2Char
 sta DisplayList0,y+21
 lda Tile4Char
 sta DisplayList0Shadow,y+21
 ;iny
 jmp skip011background

skip011
 lda bTile1Char
 sta DisplayList0,y+20
 lda bTile3Char
 sta DisplayList0Shadow,y+20 
 lda bTile2Char
 sta DisplayList0,y+21
 lda bTile4Char
 sta DisplayList0Shadow,y+21
skip011background


 txa
 and #%00000001; 8th bit set? (1st bit, had to reverse order)
 beq skip012
; tya
; ora #%11000000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+22
 lda Tile3Char
 sta DisplayList0Shadow,y+22
 ;iny
 lda Tile2Char
 sta DisplayList0,y+23
 lda Tile4Char
 sta DisplayList0Shadow,y+23
; iny
 jmp skip012background

skip012
 lda bTile1Char
 sta DisplayList0,y+22
 lda bTile3Char
 sta DisplayList0Shadow,y+22 
 lda bTile2Char
 sta DisplayList0,y+23
 lda bTile4Char
 sta DisplayList0Shadow,y+23
skip012background


;-- on to next target byte pf1(2):
; txa ; preserve X in A
; ldx c
; sty $A0+30,x ; 4th byte in row; c write offset will be 60 when b read offset is 30
; tax ; restore X from A

;; 20160525 inc c ; on to next playfield byte target, pf1(2)
; ldy #0 ; clear target
; inc b ; get 3nd byte
; tya ; preserve y

 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx d; $a0+#30,y ; from the RAM page (2nd half of where we write too) it was dropped off at ;)
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
;;ATARI 2600 FLIPS BITS HERE, FLIP THEM BACK: and #%00010000 ; first bit set?
 and #%10000000 ; first bit set?

 beq skip013
; tya
; ora #%00000011 ; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+24
 lda Tile3Char
 sta DisplayList0Shadow,y+24
; iny
 lda Tile2Char
 sta DisplayList0,y+25
 lda Tile4Char
 sta DisplayList0Shadow,y+25
; iny
 jmp skip013background

skip013
 lda bTile1Char
 sta DisplayList0,y+24
 lda bTile3Char
 sta DisplayList0Shadow,y+24 
 lda bTile2Char
 sta DisplayList0,y+25
 lda bTile4Char
 sta DisplayList0Shadow,y+25
skip013background


 txa
;Atari and #%00100000 ; 2nd bit set?
 and #%01000000 ; 2nd bit set?

 beq skip014
; tya
; ora #%00001100; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+26
 lda Tile3Char
 sta DisplayList0Shadow,y+26
 ;iny
 lda Tile2Char
 sta DisplayList0,y+27
 lda Tile4Char
 sta DisplayList0Shadow,y+27
 ;iny
 jmp skip014background

skip014
 lda bTile1Char
 sta DisplayList0,y+26
 lda bTile3Char
 sta DisplayList0Shadow,y+26
 lda bTile2Char
 sta DisplayList0,y+27
 lda bTile4Char
 sta DisplayList0Shadow,y+27
skip014background


 txa
; and #%01000000 ; 3rd bit set?
 and #%00100000 ; 3rd bit set?

 beq skip015
; tya
; ora #%00110000; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+28
 lda Tile3Char
 sta DisplayList0Shadow,y+28
; iny
 lda Tile2Char
 sta DisplayList0,y+29
 lda Tile4Char
 sta DisplayList0Shadow,y+29
 ;iny
 jmp skip015background

skip015
 lda bTile1Char
 sta DisplayList0,y+28
 lda bTile3Char
 sta DisplayList0Shadow,y+28 
 lda bTile2Char
 sta DisplayList0,y+29
 lda bTile4Char
 sta DisplayList0Shadow,y+29
skip015background

 txa
;aTARI and #%10000000; 4th bit set?
 and #%00010000; 4th bit set?

 beq skip016
; tya
; ora #%11000000; set two bits for 1 in pf1(2); done with it
; tay
 lda Tile1Char
 sta DisplayList0,y+30
 lda Tile3Char
 sta DisplayList0Shadow,y+30
; iny
 lda Tile2Char
 sta DisplayList0,y+31
 lda Tile4Char
 sta DisplayList0Shadow,y+31
 ;iny
 jmp skip016background

skip016
 lda bTile1Char
 sta DisplayList0,y+30
 lda bTile3Char
 sta DisplayList0Shadow,y+30
 lda bTile2Char
 sta DisplayList0,y+31
 lda bTile4Char
 sta DisplayList0Shadow,y+31
skip016background

 ;;txa ; preserve X in A
 ;;ldx c
 ;;;sty $A0+40,x ; 5th write; c write offset will be 60 when b read offset is 30
 ;tax ; restore x
 ;; 20160525 inc c ; on to next playfield byte target, pf2(2)
 ;;ldy #0 ; clear target

 txa
 ;Atari 2600 VCS: and #%00000001; 5th bit set?
 and #%00001000; 5th bit set?

 beq skip017
; tya
; ora #%11000000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+32
 lda Tile3Char
 sta DisplayList0Shadow,y+32

 lda Tile2Char
 sta DisplayList0,y+33
 lda Tile4Char
 sta DisplayList0Shadow,y+33
 jmp skip017background

skip017
 lda bTile1Char
 sta DisplayList0,y+32
 lda bTile3Char
 sta DisplayList0Shadow,y+32 
 lda bTile2Char
 sta DisplayList0,y+33
 lda bTile4Char
 sta DisplayList0Shadow,y+33
skip017background


 txa
;Atari and #%00000010; 6th bit set?
Atari and #%00000100; 6th bit set?

 beq skip018
; tya
; ora #%00110000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+34
 lda Tile3Char
 sta DisplayList0Shadow,y+34

 lda Tile2Char
 sta DisplayList0,y+35
 lda Tile4Char
 sta DisplayList0Shadow,y+35
 jmp skip018background

skip018
 lda bTile1Char
 sta DisplayList0,y+34
 lda bTile3Char
 sta DisplayList0Shadow,y+34 
 lda bTile2Char
 sta DisplayList0,y+35
 lda bTile4Char
 sta DisplayList0Shadow,y+35
skip018background

 txa
;Atari and #%00000100; 7th bit set?
 and #%00000010; 7th bit set?

 beq skip019
; tya
; ora #%00001100; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList0,y+36
 lda Tile3Char
 sta DisplayList0Shadow,y+36

 lda Tile2Char
 sta DisplayList0,y+37
 lda Tile4Char
 sta DisplayList0Shadow,y+37

 jmp skip019background
skip019

 lda bTile1Char
 sta DisplayList0,y+36
 lda bTile3Char
 sta DisplayList0Shadow,y+36
 lda bTile2Char
 sta DisplayList0,y+37
 lda bTile4Char
 sta DisplayList0Shadow,y+37
skip019background

 txa
;Atari and #%00001000; 8th bit set?
 and #%00000001; 8th bit set?

 beq skip020
; tya
; ora #%00000011; set twobits for 1 in pf2(2); done with it
; tay
 lda Tile1Char
 sta DisplayList0,y+38
 lda Tile3Char
 sta DisplayList0Shadow,y+38

 lda Tile2Char
 sta DisplayList0,y+39
 lda Tile4Char
 sta DisplayList0Shadow,y+39
 jmp skip020background
skip020
 lda bTile1Char
 sta DisplayList0,y+38
 lda bTile3Char
 sta DisplayList0Shadow,y+38 
 lda bTile2Char
 sta DisplayList0,y+39
 lda bTile4Char
 sta DisplayList0Shadow,y+39
skip020background

; txa ; preserve X in A
;;; ldx c
;;; sty $A0+50,x ;6th write c write offset will be 60 when b read offset is 30
 ;lda c
 ;sec
 ;sbc #5
;; 20160525 pla
;; 20160525 sta c ; restore c from cx3
 rts

;--rowsQ2--------------------------------------
rowsQ2; c is 0,80,or 160 for tile rows 1,2,3
 ;ldy #0;always 0 at start of row 0, 80 at start of row 1
 ldx a
 ;  2 bits of first byte build 4 bits of pf0 target byte in memory
 ; next two bits of it build the first 4 bits of pf1,
;--
 txa
 and #%00001000 ; keep 1st bit (1/2 byte)
; is the 1st bit set?    
 beq .skip01

 lda Tile1Char
 sta DisplayList1,y
 lda Tile3Char
 sta DisplayList1Shadow,y
 
 lda Tile2Char
 sta DisplayList1,y+1
 lda Tile4Char
 sta DisplayList1Shadow,y+1

;rem next 3
; tya
; ora #%00110000  ;set two playfield bits for 1 in pfo btye
; tay ; put it in y
 jmp .skip01background

.skip01
 lda bTile1Char
 sta DisplayList1,y
 lda bTile3Char
 sta DisplayList1Shadow,y
 
 lda bTile2Char
 sta DisplayList1,y+1
 lda bTile4Char
 sta DisplayList1Shadow,y+1
.skip01background

 txa
 and #%00000100 ; keep 2nd bit           (half byte)
; is the 2nd bit set?
 beq .skip02

 lda Tile1Char
 sta DisplayList1,y+2
 lda Tile3Char
 sta DisplayList1Shadow,y+2
 ;iny
 lda Tile2Char
 sta DisplayList1,y+3
 lda Tile4Char
 sta DisplayList1Shadow,y+3
 ;iny
; tya
; ora #%11000000 ; set next two playfield bits for 1 in pf0 byte
; tay
 jmp .skip02background
.skip02
 lda bTile1Char
 sta DisplayList1,y+2
 lda bTile3Char
 sta DisplayList1Shadow,y+2 
 lda bTile2Char
 sta DisplayList1,y+3
 lda bTile4Char
 sta DisplayList1Shadow,y+3
.skip02background

;-- write phat pf0:
;; txa ; preserve X in A
;; ldx c
 ;;sty $A0,x ; c write offset will be 60 when b read offset is 30
;; tax ; restore X
;-- remember to subtract 5 from c before rts!

;;20160525 inc c ; on to next playfield byte target, pf1
; next two bits of read b go into the next c


; ldy #0 ; clear target 
 
 txa ;x still has 1st byte from abstract ROM playfield
 and #%00000010 ; keep 3rd bit
 beq .skip03

; tya
; ora #%00110000 ; set two bits for 1 in pf1 target byte
; tay

 lda Tile1Char
 sta DisplayList1,y+4
 lda Tile3Char
 sta DisplayList1Shadow,y+4
; iny
 lda Tile2Char
 sta DisplayList1,y+5
 lda Tile4Char
 sta DisplayList1Shadow,y+5
; iny

 jmp .skip03background 
.skip03
 lda bTile1Char
 sta DisplayList1,y+4
 lda bTile3Char
 sta DisplayList1Shadow,y+4 
 lda bTile2Char
 sta DisplayList1,y+5
 lda bTile4Char
 sta DisplayList1Shadow,y+5
.skip03background

 txa ; get our byte back
 and #%00000001 ; keep 4th bit
 beq .skip04
; tya
; ora #%11000000 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList1,y+6
 lda Tile3Char
 sta DisplayList1Shadow,y+6
; iny
 lda Tile2Char
 sta DisplayList1,y+7
 lda Tile4Char
 sta DisplayList1Shadow,y+7
 ;iny
 jmp .skip04background

.skip04
 lda bTile1Char
 sta DisplayList1,y+6
 lda bTile3Char
 sta DisplayList1Shadow,y+6 
 lda bTile2Char
 sta DisplayList1,y+7
 lda bTile4Char
 sta DisplayList1Shadow,y+7
.skip04background

; ------- TRANSFORM 2nd of 3 source BYTES in the row
; inc b ; get 2nd byte
; tya ; preserve y
; ldy b
 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx b;   $a0+#30,y ; ... from the RAM page it was dropped off at!
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
 and #%10000000 ; first bit set?
 beq .skip05

; tya
; ora #%00001100 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList1,y+8
 lda Tile3Char
 sta DisplayList1Shadow,y+8
; iny
 lda Tile2Char
 sta DisplayList1,y+9
 lda Tile4Char
 sta DisplayList1Shadow,y+9
; iny
 jmp .skip05background

.skip05
 lda bTile1Char
 sta DisplayList1,y+8
 lda bTile3Char
 sta DisplayList1Shadow,y+8 
 lda bTile2Char
 sta DisplayList1,y+9
 lda bTile4Char
 sta DisplayList1Shadow,y+9
.skip05background

 txa
 and #%01000000 ; check 2nd bit set
 beq .skip06
; tya
; ora #%00000011 ; set two bits for 1 in pf1 target byte - DONE with PF1
; tay              ;* 20120801 this WAS the location of the col5 bug 00001111!
 lda Tile1Char
 sta DisplayList1,y+10
 lda Tile3Char
 sta DisplayList1Shadow,y+10
; iny
 lda Tile2Char
 sta DisplayList1,y+11
 lda Tile4Char
 sta DisplayList1Shadow,y+11
 ;iny
  jmp .skip06background

.skip06
 lda bTile1Char
 sta DisplayList1,y+10
 lda bTile3Char
 sta DisplayList1Shadow,y+10 
 lda bTile2Char
 sta DisplayList1,y+11
 lda bTile4Char
 sta DisplayList1Shadow,y+11
.skip06background

; txa ; preserve X in A
; ldx c
; already in c64 screen buffer, sty $A0+10,x ; c write offset will be 60 when b read offset is 30
; tax

;; 20160525 inc c ; on to next playfield byte target, pf2
;; ldy #0 ; clear target for 3rd byte write
 txa
 and #%00100000 ; check 3rd bit set
 beq .skip07
; tya
; ora #%00000011; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList1,y+12
 lda Tile3Char
 sta DisplayList1Shadow,y+12
; iny
 lda Tile2Char
 sta DisplayList1,y+13
 lda Tile4Char
 sta DisplayList1Shadow,y+13
 ;iny
 jmp .skip07background
.skip07
 lda bTile1Char
 sta DisplayList1,y+12
 lda bTile3Char
 sta DisplayList1Shadow,y+12 
 lda bTile2Char
 sta DisplayList1,y+13
 lda bTile4Char
 sta DisplayList1Shadow,y+13
.skip07background

 txa
 and #%00010000 ; check 4th bit set
 beq .skip08
; tya
; ora #%00001100; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList1,y+14
 lda Tile3Char
 sta DisplayList1Shadow,y+14
; iny
 lda Tile2Char
 sta DisplayList1,y+15
 lda Tile4Char
 sta DisplayList1Shadow,y+15
; iny

 jmp .skip08background

.skip08
 lda bTile1Char
 sta DisplayList1,y+14
 lda bTile3Char
 sta DisplayList1Shadow,y+14 
 lda bTile2Char
 sta DisplayList1,y+15
 lda bTile4Char
 sta DisplayList1Shadow,y+15
.skip08background


 txa
 and #%00001000; check 5th bit set
 beq .skip09
; tya
; ora #%00110000; set two bits for 1 in pf2 target byte
; tay

 lda Tile1Char
 sta DisplayList1,y+16
 lda Tile3Char
 sta DisplayList1Shadow,y+16
 ;iny
 lda Tile2Char
 sta DisplayList1,y+17
 lda Tile4Char
 sta DisplayList1Shadow,y+17
; iny
 jmp .skip09background

.skip09
 lda bTile1Char
 sta DisplayList1,y+16
 lda bTile3Char
 sta DisplayList1Shadow,y+16 
 lda bTile2Char
 sta DisplayList1,y+17
 lda bTile4Char
 sta DisplayList1Shadow,y+17
.skip09background
 
 txa
 and #%00000100; 6th bit set?
 beq .skip010


; tya
; ora #%11000000; set lasttwo bits for 1 in pf2 target byte
 ;tay
 lda Tile1Char
 sta DisplayList1,y+18
 lda Tile3Char
 sta DisplayList1Shadow,y+18
; iny
 lda Tile2Char
 sta DisplayList1,y+19
 lda Tile4Char
 sta DisplayList1Shadow,y+19
 ;iny

 jmp .skip010background
 
.skip010
 lda bTile1Char
 sta DisplayList1,y+18
 lda bTile3Char
 sta DisplayList1Shadow,y+18 
 lda bTile2Char
 sta DisplayList1,y+19
 lda bTile4Char
 sta DisplayList1Shadow,y+19
.skip010background

;-- on to next target byte pf0(2):
 txa ; preserve X in A
; ldx c
; sty $A0+20,x ; 3rd byte in row; c write offset will be 60 when b read offset is 30
 tax
;--
;; 20160525 inc c ; on to next playfield byte target, pf0(2)
; ldy #0 ; clear target

 ;20160315 txa ; superfluous here ;)
 
 and #%00000010; 7th bit set? (2nd bit, had to reverse...)
 beq .skip011
; tya
; ora #%00110000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+20
 lda Tile3Char
 sta DisplayList1Shadow,y+20
; iny
 lda Tile2Char
 sta DisplayList1,y+21
 lda Tile4Char
 sta DisplayList1Shadow,y+21
 ;iny
 jmp .skip011background

.skip011
 lda bTile1Char
 sta DisplayList1,y+20
 lda bTile3Char
 sta DisplayList1Shadow,y+20 
 lda bTile2Char
 sta DisplayList1,y+21
 lda bTile4Char
 sta DisplayList1Shadow,y+21
.skip011background

 txa
 and #%00000001; 8th bit set? (1st bit, had to reverse order)
 beq .skip012
; tya
; ora #%11000000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+22
 lda Tile3Char
 sta DisplayList1Shadow,y+22
 ;iny
 lda Tile2Char
 sta DisplayList1,y+23
 lda Tile4Char
 sta DisplayList1Shadow,y+23
; iny
 jmp .skip012background

.skip012
 lda bTile1Char
 sta DisplayList1,y+22
 lda bTile3Char
 sta DisplayList1Shadow,y+22 
 lda bTile2Char
 sta DisplayList1,y+23
 lda bTile4Char
 sta DisplayList1Shadow,y+23
.skip012background

;-- on to next target byte pf1(2):
; txa ; preserve X in A
; ldx c
; sty $A0+30,x ; 4th byte in row; c write offset will be 60 when b read offset is 30
; tax ; restore X from A

;; 20160525 inc c ; on to next playfield byte target, pf1(2)
; ldy #0 ; clear target
; inc b ; get 3nd byte
; tya ; preserve y

 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx d; $a0+#30,y ; from the RAM page (2nd half of where we write too) it was dropped off at ;)
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
;;ATARI 2600 FLIPS BITS HERE, FLIP THEM BACK: and #%00010000 ; first bit set?
 and #%10000000 ; first bit set?

 beq .skip013
; tya
; ora #%00000011 ; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+24
 lda Tile3Char
 sta DisplayList1Shadow,y+24
; iny
 lda Tile2Char
 sta DisplayList1,y+25
 lda Tile4Char
 sta DisplayList1Shadow,y+25
; iny
 jmp .skip013background

.skip013
 lda bTile1Char
 sta DisplayList1,y+24
 lda bTile3Char
 sta DisplayList1Shadow,y+24 
 lda bTile2Char
 sta DisplayList1,y+25
 lda bTile4Char
 sta DisplayList1Shadow,y+25
.skip013background

 txa
;Atari and #%00100000 ; 2nd bit set?
 and #%01000000 ; 2nd bit set?

 beq .skip014
; tya
; ora #%00001100; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+26
 lda Tile3Char
 sta DisplayList1Shadow,y+26
 ;iny
 lda Tile2Char
 sta DisplayList1,y+27
 lda Tile4Char
 sta DisplayList1Shadow,y+27
 ;iny
 jmp .skip014background

.skip014
 lda bTile1Char
 sta DisplayList1,y+26
 lda bTile3Char
 sta DisplayList1Shadow,y+26
 lda bTile2Char
 sta DisplayList1,y+27
 lda bTile4Char
 sta DisplayList1Shadow,y+27
.skip014background

 txa
; and #%01000000 ; 3rd bit set?
 and #%00100000 ; 3rd bit set?

 beq .skip015
; tya
; ora #%00110000; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+28
 lda Tile3Char
 sta DisplayList1Shadow,y+28
; iny
 lda Tile2Char
 sta DisplayList1,y+29
 lda Tile4Char
 sta DisplayList1Shadow,y+29
 ;iny
 jmp .skip015background

.skip015
 lda bTile1Char
 sta DisplayList1,y+28
 lda bTile3Char
 sta DisplayList1Shadow,y+28 
 lda bTile2Char
 sta DisplayList1,y+29
 lda bTile4Char
 sta DisplayList1Shadow,y+29
.skip015background

 txa
;aTARI and #%10000000; 4th bit set?
 and #%00010000; 4th bit set?

 beq .skip016
; tya
; ora #%11000000; set two bits for 1 in pf1(2); done with it
; tay
 lda Tile1Char
 sta DisplayList1,y+30
 lda Tile3Char
 sta DisplayList1Shadow,y+30
; iny
 lda Tile2Char
 sta DisplayList1,y+31
 lda Tile4Char
 sta DisplayList1Shadow,y+31
 ;iny
 jmp .skip016background

.skip016
 lda bTile1Char
 sta DisplayList1,y+30
 lda bTile3Char
 sta DisplayList1Shadow,y+30
 lda bTile2Char
 sta DisplayList1,y+31
 lda bTile4Char
 sta DisplayList1Shadow,y+31
.skip016background

 ;;txa ; preserve X in A
 ;;ldx c
 ;;;sty $A0+40,x ; 5th write; c write offset will be 60 when b read offset is 30
 ;tax ; restore x
 ;; 20160525 inc c ; on to next playfield byte target, pf2(2)
 ;;ldy #0 ; clear target

 txa
 ;Atari 2600 VCS: and #%00000001; 5th bit set?
 and #%00001000; 5th bit set?

 beq .skip017
; tya
; ora #%11000000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+32
 lda Tile3Char
 sta DisplayList1Shadow,y+32

 lda Tile2Char
 sta DisplayList1,y+33
 lda Tile4Char
 sta DisplayList1Shadow,y+33
 jmp .skip017background

.skip017
 lda bTile1Char
 sta DisplayList1,y+32
 lda bTile3Char
 sta DisplayList1Shadow,y+32 
 lda bTile2Char
 sta DisplayList1,y+33
 lda bTile4Char
 sta DisplayList1Shadow,y+33
.skip017background


 txa
;Atari and #%00000010; 6th bit set?
 and #%00000100; 6th bit set?

 beq .skip018
; tya
; ora #%00110000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+34
 lda Tile3Char
 sta DisplayList1Shadow,y+34

 lda Tile2Char
 sta DisplayList1,y+35
 lda Tile4Char
 sta DisplayList1Shadow,y+35
 jmp .skip018background

.skip018
 lda bTile1Char
 sta DisplayList1,y+34
 lda bTile3Char
 sta DisplayList1Shadow,y+34 
 lda bTile2Char
 sta DisplayList1,y+35
 lda bTile4Char
 sta DisplayList1Shadow,y+35
.skip018background

 txa
;Atari and #%00000100; 7th bit set?
 and #%00000010; 7th bit set?

 beq .skip019
; tya
; ora #%00001100; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList1,y+36
 lda Tile3Char
 sta DisplayList1Shadow,y+36

 lda Tile2Char
 sta DisplayList1,y+37
 lda Tile4Char
 sta DisplayList1Shadow,y+37

 jmp .skip019background
.skip019

 lda bTile1Char
 sta DisplayList1,y+36
 lda bTile3Char
 sta DisplayList1Shadow,y+36
 lda bTile2Char
 sta DisplayList1,y+37
 lda bTile4Char
 sta DisplayList1Shadow,y+37
.skip019background

 txa
;Atari and #%00001000; 8th bit set?
 and #%00000001; 8th bit set?

 beq .skip020
; tya
; ora #%00000011; set twobits for 1 in pf2(2); done with it
; tay
 lda Tile1Char
 sta DisplayList1,y+38
 lda Tile3Char
 sta DisplayList1Shadow,y+38

 lda Tile2Char
 sta DisplayList1,y+39
 lda Tile4Char
 sta DisplayList1Shadow,y+39
 jmp .skip020background
.skip020
 lda bTile1Char
 sta DisplayList1,y+38
 lda bTile3Char
 sta DisplayList1Shadow,y+38 
 lda bTile2Char
 sta DisplayList1,y+39
 lda bTile4Char
 sta DisplayList1Shadow,y+39
.skip020background
;; 20160525 pla
;; 20160525 sta c ; restore c from cx3

 rts
;--end rowsQ2----------------------------------

;----------------------------------------------
;--rowsQ3--------------------------------------
rowsQ3; c is 0,80,or 160 for tile rows 1,2,3
 ;ldy #0;always 0 at start of row 0, 80 at start of row 1
 ldx a
 ;  2 bits of first byte build 4 bits of pf0 target byte in memory
 ; next two bits of it build the first 4 bits of pf1,
;--
 txa
 and #%00001000 ; keep 1st bit (1/2 byte)
; is the 1st bit set?    
 beq .skip01a

 lda Tile1Char
 sta DisplayList2,y
 lda Tile3Char
 sta DisplayList2Shadow,y
 
 lda Tile2Char
 sta DisplayList2,y+1
 lda Tile4Char
 sta DisplayList2Shadow,y+1

;rem next 3
; tya
; ora #%00110000  ;set two playfield bits for 1 in pfo btye
; tay ; put it in y
 jmp .skip01backgrounda

.skip01a
 lda bTile1Char
 sta DisplayList2,y
 lda bTile3Char
 sta DisplayList2Shadow,y
 
 lda bTile2Char
 sta DisplayList2,y+1
 lda bTile4Char
 sta DisplayList2Shadow,y+1
.skip01backgrounda

 txa
 and #%00000100 ; keep 2nd bit           (half byte)
; is the 2nd bit set?
 beq .skip02a

 lda Tile1Char
 sta DisplayList2,y+2
 lda Tile3Char
 sta DisplayList2Shadow,y+2
 ;iny
 lda Tile2Char
 sta DisplayList2,y+3
 lda Tile4Char
 sta DisplayList2Shadow,y+3
 ;iny
; tya
; ora #%11000000 ; set next two playfield bits for 1 in pf0 byte
; tay
 jmp .skip02backgrounda
.skip02a
 lda bTile1Char
 sta DisplayList2,y+2
 lda bTile3Char
 sta DisplayList2Shadow,y+2 
 lda bTile2Char
 sta DisplayList2,y+3
 lda bTile4Char
 sta DisplayList2Shadow,y+3
.skip02backgrounda

;-- write phat pf0:
;; txa ; preserve X in A
;; ldx c
 ;;sty $A0,x ; c write offset will be 60 when b read offset is 30
;; tax ; restore X
;-- remember to subtract 5 from c before rts!

;;20160525 inc c ; on to next playfield byte target, pf1
; next two bits of read b go into the next c


; ldy #0 ; clear target 
 
 txa ;x still has 1st byte from abstract ROM playfield
 and #%00000010 ; keep 3rd bit
 beq .skip03a

; tya
; ora #%00110000 ; set two bits for 1 in pf1 target byte
; tay

 lda Tile1Char
 sta DisplayList2,y+4
 lda Tile3Char
 sta DisplayList2Shadow,y+4
; iny
 lda Tile2Char
 sta DisplayList2,y+5
 lda Tile4Char
 sta DisplayList2Shadow,y+5
; iny

 jmp .skip03backgrounda 
.skip03a
 lda bTile1Char
 sta DisplayList2,y+4
 lda bTile3Char
 sta DisplayList2Shadow,y+4 
 lda bTile2Char
 sta DisplayList2,y+5
 lda bTile4Char
 sta DisplayList2Shadow,y+5
.skip03backgrounda

 txa ; get our byte back
 and #%00000001 ; keep 4th bit
 beq .skip04a
; tya
; ora #%11000000 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList2,y+6
 lda Tile3Char
 sta DisplayList2Shadow,y+6
; iny
 lda Tile2Char
 sta DisplayList2,y+7
 lda Tile4Char
 sta DisplayList2Shadow,y+7
 ;iny
 jmp .skip04backgrounda

.skip04a
 lda bTile1Char
 sta DisplayList2,y+6
 lda bTile3Char
 sta DisplayList2Shadow,y+6 
 lda bTile2Char
 sta DisplayList2,y+7
 lda bTile4Char
 sta DisplayList2Shadow,y+7
.skip04backgrounda

; ------- TRANSFORM 2nd of 3 source BYTES in the row
; inc b ; get 2nd byte
; tya ; preserve y
; ldy b
 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx b;   $a0+#30,y ; ... from the RAM page it was dropped off at!
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
 and #%10000000 ; first bit set?
 beq .skip05a

; tya
; ora #%00001100 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList2,y+8
 lda Tile3Char
 sta DisplayList2Shadow,y+8
; iny
 lda Tile2Char
 sta DisplayList2,y+9
 lda Tile4Char
 sta DisplayList2Shadow,y+9
; iny
 jmp .skip05backgrounda

.skip05a
 lda bTile1Char
 sta DisplayList2,y+8
 lda bTile3Char
 sta DisplayList2Shadow,y+8 
 lda bTile2Char
 sta DisplayList2,y+9
 lda bTile4Char
 sta DisplayList2Shadow,y+9
.skip05backgrounda

 txa
 and #%01000000 ; check 2nd bit set
 beq .skip06a
; tya
; ora #%00000011 ; set two bits for 1 in pf1 target byte - DONE with PF1
; tay              ;* 20120801 this WAS the location of the col5 bug 00001111!
 lda Tile1Char
 sta DisplayList2,y+10
 lda Tile3Char
 sta DisplayList2Shadow,y+10
; iny
 lda Tile2Char
 sta DisplayList2,y+11
 lda Tile4Char
 sta DisplayList2Shadow,y+11
 ;iny
  jmp .skip06backgrounda

.skip06a
 lda bTile1Char
 sta DisplayList2,y+10
 lda bTile3Char
 sta DisplayList2Shadow,y+10 
 lda bTile2Char
 sta DisplayList2,y+11
 lda bTile4Char
 sta DisplayList2Shadow,y+11
.skip06backgrounda

; txa ; preserve X in A
; ldx c
; already in c64 screen buffer, sty $A0+10,x ; c write offset will be 60 when b read offset is 30
; tax

;; 20160525 inc c ; on to next playfield byte target, pf2
;; ldy #0 ; clear target for 3rd byte write
 txa
 and #%00100000 ; check 3rd bit set
 beq .skip07a
; tya
; ora #%00000011; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList2,y+12
 lda Tile3Char
 sta DisplayList2Shadow,y+12
; iny
 lda Tile2Char
 sta DisplayList2,y+13
 lda Tile4Char
 sta DisplayList2Shadow,y+13
 ;iny
 jmp .skip07backgrounda
.skip07a
 lda bTile1Char
 sta DisplayList2,y+12
 lda bTile3Char
 sta DisplayList2Shadow,y+12 
 lda bTile2Char
 sta DisplayList2,y+13
 lda bTile4Char
 sta DisplayList2Shadow,y+13
.skip07backgrounda

 txa
 and #%00010000 ; check 4th bit set
 beq .skip08a
; tya
; ora #%00001100; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList2,y+14
 lda Tile3Char
 sta DisplayList2Shadow,y+14
; iny
 lda Tile2Char
 sta DisplayList2,y+15
 lda Tile4Char
 sta DisplayList2Shadow,y+15
; iny

 jmp .skip08backgrounda

.skip08a
 lda bTile1Char
 sta DisplayList2,y+14
 lda bTile3Char
 sta DisplayList2Shadow,y+14 
 lda bTile2Char
 sta DisplayList2,y+15
 lda bTile4Char
 sta DisplayList2Shadow,y+15
.skip08backgrounda


 txa
 and #%00001000; check 5th bit set
 beq .skip09a
; tya
; ora #%00110000; set two bits for 1 in pf2 target byte
; tay

 lda Tile1Char
 sta DisplayList2,y+16
 lda Tile3Char
 sta DisplayList2Shadow,y+16
 ;iny
 lda Tile2Char
 sta DisplayList2,y+17
 lda Tile4Char
 sta DisplayList2Shadow,y+17
; iny
 jmp .skip09backgrounda

.skip09a
 lda bTile1Char
 sta DisplayList2,y+16
 lda bTile3Char
 sta DisplayList2Shadow,y+16 
 lda bTile2Char
 sta DisplayList2,y+17
 lda bTile4Char
 sta DisplayList2Shadow,y+17
.skip09backgrounda
 
 txa
 and #%00000100; 6th bit set?
 beq .skip010a


; tya
; ora #%11000000; set lasttwo bits for 1 in pf2 target byte
 ;tay
 lda Tile1Char
 sta DisplayList2,y+18
 lda Tile3Char
 sta DisplayList2Shadow,y+18
; iny
 lda Tile2Char
 sta DisplayList2,y+19
 lda Tile4Char
 sta DisplayList2Shadow,y+19
 ;iny

 jmp .skip010backgrounda
 
.skip010a
 lda bTile1Char
 sta DisplayList2,y+18
 lda bTile3Char
 sta DisplayList2Shadow,y+18 
 lda bTile2Char
 sta DisplayList2,y+19
 lda bTile4Char
 sta DisplayList2Shadow,y+19
.skip010backgrounda

;-- on to next target byte pf0(2):
 txa ; preserve X in A
; ldx c
; sty $A0+20,x ; 3rd byte in row; c write offset will be 60 when b read offset is 30
 tax
;--
;; 20160525 inc c ; on to next playfield byte target, pf0(2)
; ldy #0 ; clear target

 ;20160315 txa ; superfluous here ;)
 
 and #%00000010; 7th bit set? (2nd bit, had to reverse...)
 beq .skip011a
; tya
; ora #%00110000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+20
 lda Tile3Char
 sta DisplayList2Shadow,y+20
; iny
 lda Tile2Char
 sta DisplayList2,y+21
 lda Tile4Char
 sta DisplayList2Shadow,y+21
 ;iny
 jmp .skip011backgrounda

.skip011a
 lda bTile1Char
 sta DisplayList2,y+20
 lda bTile3Char
 sta DisplayList2Shadow,y+20 
 lda bTile2Char
 sta DisplayList2,y+21
 lda bTile4Char
 sta DisplayList2Shadow,y+21
.skip011backgrounda

 txa
 and #%00000001; 8th bit set? (1st bit, had to reverse order)
 beq .skip012a
; tya
; ora #%11000000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+22
 lda Tile3Char
 sta DisplayList2Shadow,y+22
 ;iny
 lda Tile2Char
 sta DisplayList2,y+23
 lda Tile4Char
 sta DisplayList2Shadow,y+23
; iny
 jmp .skip012backgrounda

.skip012a
 lda bTile1Char
 sta DisplayList2,y+22
 lda bTile3Char
 sta DisplayList2Shadow,y+22 
 lda bTile2Char
 sta DisplayList2,y+23
 lda bTile4Char
 sta DisplayList2Shadow,y+23
.skip012backgrounda

;-- on to next target byte pf1(2):
; txa ; preserve X in A
; ldx c
; sty $A0+30,x ; 4th byte in row; c write offset will be 60 when b read offset is 30
; tax ; restore X from A

;; 20160525 inc c ; on to next playfield byte target, pf1(2)
; ldy #0 ; clear target
; inc b ; get 3nd byte
; tya ; preserve y

 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx d; $a0+#30,y ; from the RAM page (2nd half of where we write too) it was dropped off at ;)
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
;;ATARI 2600 FLIPS BITS HERE, FLIP THEM BACK: and #%00010000 ; first bit set?
 and #%10000000 ; first bit set?

 beq .skip013a
; tya
; ora #%00000011 ; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+24
 lda Tile3Char
 sta DisplayList2Shadow,y+24
; iny
 lda Tile2Char
 sta DisplayList2,y+25
 lda Tile4Char
 sta DisplayList2Shadow,y+25
; iny
 jmp .skip013backgrounda

.skip013a
 lda bTile1Char
 sta DisplayList2,y+24
 lda bTile3Char
 sta DisplayList2Shadow,y+24 
 lda bTile2Char
 sta DisplayList2,y+25
 lda bTile4Char
 sta DisplayList2Shadow,y+25
.skip013backgrounda


 txa
;Atari and #%00100000 ; 2nd bit set?
 and #%01000000 ; 2nd bit set?

 beq .skip014a
; tya
; ora #%00001100; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+26
 lda Tile3Char
 sta DisplayList2Shadow,y+26
 ;iny
 lda Tile2Char
 sta DisplayList2,y+27
 lda Tile4Char
 sta DisplayList2Shadow,y+27
 ;iny
 jmp .skip014backgrounda

.skip014a
 lda bTile1Char
 sta DisplayList2,y+26
 lda bTile3Char
 sta DisplayList2Shadow,y+26
 lda bTile2Char
 sta DisplayList2,y+27
 lda bTile4Char
 sta DisplayList2Shadow,y+27
.skip014backgrounda

 txa
; and #%01000000 ; 3rd bit set?
 and #%00100000 ; 3rd bit set?

 beq .skip015a
; tya
; ora #%00110000; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+28
 lda Tile3Char
 sta DisplayList2Shadow,y+28
; iny
 lda Tile2Char
 sta DisplayList2,y+29
 lda Tile4Char
 sta DisplayList2Shadow,y+29
 ;iny
 jmp .skip015backgrounda

.skip015a
 lda bTile1Char
 sta DisplayList2,y+28
 lda bTile3Char
 sta DisplayList2Shadow,y+28 
 lda bTile2Char
 sta DisplayList2,y+29
 lda bTile4Char
 sta DisplayList2Shadow,y+29
.skip015backgrounda

 txa
;aTARI and #%10000000; 4th bit set?
 and #%00010000; 4th bit set?

 beq .skip016a
; tya
; ora #%11000000; set two bits for 1 in pf1(2); done with it
; tay
 lda Tile1Char
 sta DisplayList2,y+30
 lda Tile3Char
 sta DisplayList2Shadow,y+30
; iny
 lda Tile2Char
 sta DisplayList2,y+31
 lda Tile4Char
 sta DisplayList2Shadow,y+31
 ;iny
 jmp .skip016backgrounda

.skip016a
 lda bTile1Char
 sta DisplayList2,y+30
 lda bTile3Char
 sta DisplayList2Shadow,y+30
 lda bTile2Char
 sta DisplayList2,y+31
 lda bTile4Char
 sta DisplayList2Shadow,y+31
.skip016backgrounda

 ;;txa ; preserve X in A
 ;;ldx c
 ;;;sty $A0+40,x ; 5th write; c write offset will be 60 when b read offset is 30
 ;tax ; restore x
 ;; 20160525 inc c ; on to next playfield byte target, pf2(2)
 ;;ldy #0 ; clear target

 txa
 ;Atari 2600 VCS: and #%00000001; 5th bit set?
 and #%00001000; 5th bit set?

 beq .skip017a
; tya
; ora #%11000000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+32
 lda Tile3Char
 sta DisplayList2Shadow,y+32

 lda Tile2Char
 sta DisplayList2,y+33
 lda Tile4Char
 sta DisplayList2Shadow,y+33
 jmp .skip017backgrounda

.skip017a
 lda bTile1Char
 sta DisplayList2,y+32
 lda bTile3Char
 sta DisplayList2Shadow,y+32 
 lda bTile2Char
 sta DisplayList2,y+33
 lda bTile4Char
 sta DisplayList2Shadow,y+33
.skip017backgrounda


 txa
;Atari and #%00000010; 6th bit set?
 and #%00000100; 6th bit set?

 beq .skip018a
; tya
; ora #%00110000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+34
 lda Tile3Char
 sta DisplayList2Shadow,y+34

 lda Tile2Char
 sta DisplayList2,y+35
 lda Tile4Char
 sta DisplayList2Shadow,y+35
 jmp .skip018backgrounda

.skip018a
 lda bTile1Char
 sta DisplayList2,y+34
 lda bTile3Char
 sta DisplayList2Shadow,y+34 
 lda bTile2Char
 sta DisplayList2,y+35
 lda bTile4Char
 sta DisplayList2Shadow,y+35
.skip018backgrounda

 txa
;Atari and #%00000100; 7th bit set?
 and #%00000010; 7th bit set?

 beq .skip019a
; tya
; ora #%00001100; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList2,y+36
 lda Tile3Char
 sta DisplayList2Shadow,y+36

 lda Tile2Char
 sta DisplayList2,y+37
 lda Tile4Char
 sta DisplayList2Shadow,y+37

 jmp .skip019backgrounda
.skip019a

 lda bTile1Char
 sta DisplayList2,y+36
 lda bTile3Char
 sta DisplayList2Shadow,y+36
 lda bTile2Char
 sta DisplayList2,y+37
 lda bTile4Char
 sta DisplayList2Shadow,y+37
.skip019backgrounda

 txa
;Atari and #%00001000; 8th bit set?
 and #%00000001; 8th bit set?

 beq .skip020a
; tya
; ora #%00000011; set twobits for 1 in pf2(2); done with it
; tay
 lda Tile1Char
 sta DisplayList2,y+38
 lda Tile3Char
 sta DisplayList2Shadow,y+38

 lda Tile2Char
 sta DisplayList2,y+39
 lda Tile4Char
 sta DisplayList2Shadow,y+39
 jmp .skip020backgrounda
.skip020a
 lda bTile1Char
 sta DisplayList2,y+38
 lda bTile3Char
 sta DisplayList2Shadow,y+38 
 lda bTile2Char
 sta DisplayList2,y+39
 lda bTile4Char
 sta DisplayList2Shadow,y+39
.skip020backgrounda
;; 20160525 pla
;; 20160525 sta c ; restore c from cx3

 rts

;--end rowsQ3----------------------------------

;----------------------------------------------
;--rowsQ4--------------------------------------
rowsQ4; c is 0,80,or 160 for tile rows 1,2,3
 ;ldy #0;always 0 at start of row 0, 80 at start of row 1
 ldx a
 ;  2 bits of first byte build 4 bits of pf0 target byte in memory
 ; next two bits of it build the first 4 bits of pf1,
;--
 txa
 and #%00001000 ; keep 1st bit (1/2 byte)
; is the 1st bit set?    
 beq .bskip01a

 lda Tile1Char
 sta DisplayList3,y
 lda Tile3Char
 sta DisplayList3Shadow,y
 
 lda Tile2Char
 sta DisplayList3,y+1
 lda Tile4Char
 sta DisplayList3Shadow,y+1

;rem next 3
; tya
; ora #%00110000  ;set two playfield bits for 1 in pfo btye
; tay ; put it in y
 jmp .bskip01backgrounda

.bskip01a
 lda bTile1Char
 sta DisplayList3,y
 lda bTile3Char
 sta DisplayList3Shadow,y
 
 lda bTile2Char
 sta DisplayList3,y+1
 lda bTile4Char
 sta DisplayList3Shadow,y+1
.bskip01backgrounda

 txa
 and #%00000100 ; keep 2nd bit           (half byte)
; is the 2nd bit set?
 beq .bskip02a

 lda Tile1Char
 sta DisplayList3,y+2
 lda Tile3Char
 sta DisplayList3Shadow,y+2
 ;iny
 lda Tile2Char
 sta DisplayList3,y+3
 lda Tile4Char
 sta DisplayList3Shadow,y+3
 ;iny
; tya
; ora #%11000000 ; set next two playfield bits for 1 in pf0 byte
; tay
 jmp .bskip02backgrounda
.bskip02a
 lda bTile1Char
 sta DisplayList3,y+2
 lda bTile3Char
 sta DisplayList3Shadow,y+2 
 lda bTile2Char
 sta DisplayList3,y+3
 lda bTile4Char
 sta DisplayList3Shadow,y+3
.bskip02backgrounda

;-- write phat pf0:
;; txa ; preserve X in A
;; ldx c
 ;;sty $A0,x ; c write offset will be 60 when b read offset is 30
;; tax ; restore X
;-- remember to subtract 5 from c before rts!

;;20160525 inc c ; on to next playfield byte target, pf1
; next two bits of read b go into the next c


; ldy #0 ; clear target 
 
 txa ;x still has 1st byte from abstract ROM playfield
 and #%00000010 ; keep 3rd bit
 beq .bskip03a

; tya
; ora #%00110000 ; set two bits for 1 in pf1 target byte
; tay

 lda Tile1Char
 sta DisplayList3,y+4
 lda Tile3Char
 sta DisplayList3Shadow,y+4
; iny
 lda Tile2Char
 sta DisplayList3,y+5
 lda Tile4Char
 sta DisplayList3Shadow,y+5
; iny

 jmp .bskip03backgrounda 
.bskip03a
 lda bTile1Char
 sta DisplayList3,y+4
 lda bTile3Char
 sta DisplayList3Shadow,y+4 
 lda bTile2Char
 sta DisplayList3,y+5
 lda bTile4Char
 sta DisplayList3Shadow,y+5
.bskip03backgrounda

 txa ; get our byte back
 and #%00000001 ; keep 4th bit
 beq .bskip04a
; tya
; ora #%11000000 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList3,y+6
 lda Tile3Char
 sta DisplayList3Shadow,y+6
; iny
 lda Tile2Char
 sta DisplayList3,y+7
 lda Tile4Char
 sta DisplayList3Shadow,y+7
 ;iny
 jmp .bskip04backgrounda

.bskip04a
 lda bTile1Char
 sta DisplayList3,y+6
 lda bTile3Char
 sta DisplayList3Shadow,y+6 
 lda bTile2Char
 sta DisplayList3,y+7
 lda bTile4Char
 sta DisplayList3Shadow,y+7
.bskip04backgrounda

; ------- TRANSFORM 2nd of 3 source BYTES in the row
; inc b ; get 2nd byte
; tya ; preserve y
; ldy b
 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx b;   $a0+#30,y ; .b.b.b from the RAM page it was dropped off at!
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
 and #%10000000 ; first bit set?
 beq .bskip05a

; tya
; ora #%00001100 ; set two bits for 1 in pf1 target byte
; tay
 lda Tile1Char
 sta DisplayList3,y+8
 lda Tile3Char
 sta DisplayList3Shadow,y+8
; iny
 lda Tile2Char
 sta DisplayList3,y+9
 lda Tile4Char
 sta DisplayList3Shadow,y+9
; iny
 jmp .bskip05backgrounda

.bskip05a
 lda bTile1Char
 sta DisplayList3,y+8
 lda bTile3Char
 sta DisplayList3Shadow,y+8 
 lda bTile2Char
 sta DisplayList3,y+9
 lda bTile4Char
 sta DisplayList3Shadow,y+9
.bskip05backgrounda

 txa
 and #%01000000 ; check 2nd bit set
 beq .bskip06a
; tya
; ora #%00000011 ; set two bits for 1 in pf1 target byte - DONE with PF1
; tay              ;* 20120801 this WAS the location of the col5 bug 00001111!
 lda Tile1Char
 sta DisplayList3,y+10
 lda Tile3Char
 sta DisplayList3Shadow,y+10
; iny
 lda Tile2Char
 sta DisplayList3,y+11
 lda Tile4Char
 sta DisplayList3Shadow,y+11
 ;iny
  jmp .bskip06backgrounda

.bskip06a
 lda bTile1Char
 sta DisplayList3,y+10
 lda bTile3Char
 sta DisplayList3Shadow,y+10 
 lda bTile2Char
 sta DisplayList3,y+11
 lda bTile4Char
 sta DisplayList3Shadow,y+11
.bskip06backgrounda

; txa ; preserve X in A
; ldx c
; already in c64 screen buffer, sty $A0+10,x ; c write offset will be 60 when b read offset is 30
; tax

;; 20160525 inc c ; on to next playfield byte target, pf2
;; ldy #0 ; clear target for 3rd byte write
 txa
 and #%00100000 ; check 3rd bit set
 beq .bskip07a
; tya
; ora #%00000011; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList3,y+12
 lda Tile3Char
 sta DisplayList3Shadow,y+12
; iny
 lda Tile2Char
 sta DisplayList3,y+13
 lda Tile4Char
 sta DisplayList3Shadow,y+13
 ;iny
 jmp .bskip07backgrounda
.bskip07a
 lda bTile1Char
 sta DisplayList3,y+12
 lda bTile3Char
 sta DisplayList3Shadow,y+12 
 lda bTile2Char
 sta DisplayList3,y+13
 lda bTile4Char
 sta DisplayList3Shadow,y+13
.bskip07backgrounda

 txa
 and #%00010000 ; check 4th bit set
 beq .bskip08a
; tya
; ora #%00001100; set two bits for 1 in pf2 target byte
; tay
 lda Tile1Char
 sta DisplayList3,y+14
 lda Tile3Char
 sta DisplayList3Shadow,y+14
; iny
 lda Tile2Char
 sta DisplayList3,y+15
 lda Tile4Char
 sta DisplayList3Shadow,y+15
; iny

 jmp .bskip08backgrounda

.bskip08a
 lda bTile1Char
 sta DisplayList3,y+14
 lda bTile3Char
 sta DisplayList3Shadow,y+14 
 lda bTile2Char
 sta DisplayList3,y+15
 lda bTile4Char
 sta DisplayList3Shadow,y+15
.bskip08backgrounda


 txa
 and #%00001000; check 5th bit set
 beq .bskip09a
; tya
; ora #%00110000; set two bits for 1 in pf2 target byte
; tay

 lda Tile1Char
 sta DisplayList3,y+16
 lda Tile3Char
 sta DisplayList3Shadow,y+16
 ;iny
 lda Tile2Char
 sta DisplayList3,y+17
 lda Tile4Char
 sta DisplayList3Shadow,y+17
; iny
 jmp .bskip09backgrounda

.bskip09a
 lda bTile1Char
 sta DisplayList3,y+16
 lda bTile3Char
 sta DisplayList3Shadow,y+16 
 lda bTile2Char
 sta DisplayList3,y+17
 lda bTile4Char
 sta DisplayList3Shadow,y+17
.bskip09backgrounda
 
 txa
 and #%00000100; 6th bit set?
 beq .bskip010a


; tya
; ora #%11000000; set lasttwo bits for 1 in pf2 target byte
 ;tay
 lda Tile1Char
 sta DisplayList3,y+18
 lda Tile3Char
 sta DisplayList3Shadow,y+18
; iny
 lda Tile2Char
 sta DisplayList3,y+19
 lda Tile4Char
 sta DisplayList3Shadow,y+19
 ;iny

 jmp .bskip010backgrounda
 
.bskip010a
 lda bTile1Char
 sta DisplayList3,y+18
 lda bTile3Char
 sta DisplayList3Shadow,y+18 
 lda bTile2Char
 sta DisplayList3,y+19
 lda bTile4Char
 sta DisplayList3Shadow,y+19
.bskip010backgrounda

;-- on to next target byte pf0(2):
 txa ; preserve X in A
; ldx c
; sty $A0+20,x ; 3rd byte in row; c write offset will be 60 when b read offset is 30
 tax
;--
;; 20160525 inc c ; on to next playfield byte target, pf0(2)
; ldy #0 ; clear target

 ;20160315 txa ; superfluous here ;)
 
 and #%00000010; 7th bit set? (2nd bit, had to reverse.b.b.b)
 beq .bskip011a
; tya
; ora #%00110000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+20
 lda Tile3Char
 sta DisplayList3Shadow,y+20
; iny
 lda Tile2Char
 sta DisplayList3,y+21
 lda Tile4Char
 sta DisplayList3Shadow,y+21
 ;iny
 jmp .bskip011backgrounda

.bskip011a
 lda bTile1Char
 sta DisplayList3,y+20
 lda bTile3Char
 sta DisplayList3Shadow,y+20 
 lda bTile2Char
 sta DisplayList3,y+21
 lda bTile4Char
 sta DisplayList3Shadow,y+21
.bskip011backgrounda

 txa
 and #%00000001; 8th bit set? (1st bit, had to reverse order)
 beq .bskip012a
; tya
; ora #%11000000 ; set two bits for 1 in pf0(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+22
 lda Tile3Char
 sta DisplayList3Shadow,y+22
 ;iny
 lda Tile2Char
 sta DisplayList3,y+23
 lda Tile4Char
 sta DisplayList3Shadow,y+23
; iny
 jmp .bskip012backgrounda

.bskip012a
 lda bTile1Char
 sta DisplayList3,y+22
 lda bTile3Char
 sta DisplayList3Shadow,y+22 
 lda bTile2Char
 sta DisplayList3,y+23
 lda bTile4Char
 sta DisplayList3Shadow,y+23
.bskip012backgrounda

;-- on to next target byte pf1(2):
; txa ; preserve X in A
; ldx c
; sty $A0+30,x ; 4th byte in row; c write offset will be 60 when b read offset is 30
; tax ; restore X from A

;; 20160525 inc c ; on to next playfield byte target, pf1(2)
; ldy #0 ; clear target
; inc b ; get 3nd byte
; tya ; preserve y

 ;ldx MyAbstractPlayfield,y; get rom playfield byte
 ldx d; $a0+#30,y ; from the RAM page (2nd half of where we write too) it was dropped off at ;)
; tay ; restore y
 txa ; x now has 2nd byte (of 3 in row) from abstract ROM playfield
;;ATARI 2600 FLIPS BITS HERE, FLIP THEM BACK: and #%00010000 ; first bit set?
 and #%10000000 ; first bit set?

 beq .bskip013a
; tya
; ora #%00000011 ; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+24
 lda Tile3Char
 sta DisplayList3Shadow,y+24
; iny
 lda Tile2Char
 sta DisplayList3,y+25
 lda Tile4Char
 sta DisplayList3Shadow,y+25
; iny
 jmp .bskip013backgrounda

.bskip013a
 lda bTile1Char
 sta DisplayList3,y+24
 lda bTile3Char
 sta DisplayList3Shadow,y+24 
 lda bTile2Char
 sta DisplayList3,y+25
 lda bTile4Char
 sta DisplayList3Shadow,y+25
.bskip013backgrounda


 txa
;Atari and #%00100000 ; 2nd bit set?
 and #%01000000 ; 2nd bit set?

 beq .bskip014a
; tya
; ora #%00001100; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+26
 lda Tile3Char
 sta DisplayList3Shadow,y+26
 ;iny
 lda Tile2Char
 sta DisplayList3,y+27
 lda Tile4Char
 sta DisplayList3Shadow,y+27
 ;iny
 jmp .bskip014backgrounda

.bskip014a
 lda bTile1Char
 sta DisplayList3,y+26
 lda bTile3Char
 sta DisplayList3Shadow,y+26
 lda bTile2Char
 sta DisplayList3,y+27
 lda bTile4Char
 sta DisplayList3Shadow,y+27
.bskip014backgrounda

 txa
; and #%01000000 ; 3rd bit set?
 and #%00100000 ; 3rd bit set?

 beq .bskip015a
; tya
; ora #%00110000; set two bits for 1 in pf1(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+28
 lda Tile3Char
 sta DisplayList3Shadow,y+28
; iny
 lda Tile2Char
 sta DisplayList3,y+29
 lda Tile4Char
 sta DisplayList3Shadow,y+29
 ;iny
 jmp .bskip015backgrounda

.bskip015a
 lda bTile1Char
 sta DisplayList3,y+28
 lda bTile3Char
 sta DisplayList3Shadow,y+28 
 lda bTile2Char
 sta DisplayList3,y+29
 lda bTile4Char
 sta DisplayList3Shadow,y+29
.bskip015backgrounda

 txa
;aTARI and #%10000000; 4th bit set?
 and #%00010000; 4th bit set?

 beq .bskip016a
; tya
; ora #%11000000; set two bits for 1 in pf1(2); done with it
; tay
 lda Tile1Char
 sta DisplayList3,y+30
 lda Tile3Char
 sta DisplayList3Shadow,y+30
; iny
 lda Tile2Char
 sta DisplayList3,y+31
 lda Tile4Char
 sta DisplayList3Shadow,y+31
 ;iny
 jmp .bskip016backgrounda

.bskip016a
 lda bTile1Char
 sta DisplayList3,y+30
 lda bTile3Char
 sta DisplayList3Shadow,y+30
 lda bTile2Char
 sta DisplayList3,y+31
 lda bTile4Char
 sta DisplayList3Shadow,y+31
.bskip016backgrounda

 ;;txa ; preserve X in A
 ;;ldx c
 ;;;sty $A0+40,x ; 5th write; c write offset will be 60 when b read offset is 30
 ;tax ; restore x
 ;; 20160525 inc c ; on to next playfield byte target, pf2(2)
 ;;ldy #0 ; clear target

 txa
 ;Atari 2600 VCS: and #%00000001; 5th bit set?
 and #%00001000; 5th bit set?

 beq .bskip017a
; tya
; ora #%11000000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+32
 lda Tile3Char
 sta DisplayList3Shadow,y+32

 lda Tile2Char
 sta DisplayList3,y+33
 lda Tile4Char
 sta DisplayList3Shadow,y+33
 jmp .bskip017backgrounda

.bskip017a
 lda bTile1Char
 sta DisplayList3,y+32
 lda bTile3Char
 sta DisplayList3Shadow,y+32 
 lda bTile2Char
 sta DisplayList3,y+33
 lda bTile4Char
 sta DisplayList3Shadow,y+33
.bskip017backgrounda


 txa
;Atari and #%00000010; 6th bit set?
 and #%00000100; 6th bit set?

 beq .bskip018a
; tya
; ora #%00110000; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+34
 lda Tile3Char
 sta DisplayList3Shadow,y+34

 lda Tile2Char
 sta DisplayList3,y+35
 lda Tile4Char
 sta DisplayList3Shadow,y+35
 jmp .bskip018backgrounda

.bskip018a
 lda bTile1Char
 sta DisplayList3,y+34
 lda bTile3Char
 sta DisplayList3Shadow,y+34 
 lda bTile2Char
 sta DisplayList3,y+35
 lda bTile4Char
 sta DisplayList3Shadow,y+35
.bskip018backgrounda

 txa
;Atari and #%00000100; 7th bit set?
 and #%00000010; 7th bit set?

 beq .bskip019a
; tya
; ora #%00001100; set two bits for 1 in pf2(2)
; tay
 lda Tile1Char
 sta DisplayList3,y+36
 lda Tile3Char
 sta DisplayList3Shadow,y+36

 lda Tile2Char
 sta DisplayList3,y+37
 lda Tile4Char
 sta DisplayList3Shadow,y+37

 jmp .bskip019backgrounda
.bskip019a

 lda bTile1Char
 sta DisplayList3,y+36
 lda bTile3Char
 sta DisplayList3Shadow,y+36
 lda bTile2Char
 sta DisplayList3,y+37
 lda bTile4Char
 sta DisplayList3Shadow,y+37
.bskip019backgrounda

 txa
;Atari and #%00001000; 8th bit set?
 and #%00000001; 8th bit set?

 beq .bskip020a
; tya
; ora #%00000011; set twobits for 1 in pf2(2); done with it
; tay
 lda Tile1Char
 sta DisplayList3,y+38
 lda Tile3Char
 sta DisplayList3Shadow,y+38

 lda Tile2Char
 sta DisplayList3,y+39
 lda Tile4Char
 sta DisplayList3Shadow,y+39
 jmp .bskip020backgrounda
.bskip020a
 lda bTile1Char
 sta DisplayList3,y+38
 lda bTile3Char
 sta DisplayList3Shadow,y+38 
 lda bTile2Char
 sta DisplayList3,y+39
 lda bTile4Char
 sta DisplayList3Shadow,y+39
.bskip020backgrounda
;; 20160525 pla
;; 20160525 sta c ; restore c from cx3

 rts

;--end rowsQ4----------------------------------



; end transposer AND
; end --- pushabstractextendedplayfield
;---------------------------------------

;20220529 c64 relocating gameloop test, leaving gameloop2 unaligned
; fixed many games that froze...
; 20220529 C64 repeating relocation with gameloop2 fixed SC Space Invaders

;---------------------------------------------------

;--------------------------
;-- init section ----------
initsection 
; ldx #25
; lda #0
;clearsidregs dex
; sta SIDvoice1,x
; bne clearsidregs
 ;lda #0
 ;sta MUSICINDEX

 ;lda #%01111111
 ;sta $d418 ; turn on low pass filter and max vol on SID

 ;sta SUSTAINFORFRAMES ; check bug?

;20240120 SID opt, sustain release
; lda #%11110010; max sustain volume moderate release
 ;lda #%11110100; max sustain volume moderate release

;  lda #%11110100; max sustain volume moderate release
;   lda #%11111001; max sustain volume mAX release

   ; lda #%11110001; max sustain volume min release
  ;lda #%11110100; max sustain volume moderate release

    lda #%10110100;

 sta $D406; voice1
 sta $d414; voice3
 sta $d40d; voice2
 lda #%10101011
 sta $D415
 sta $D416

c64init
REPLACEINIT
  ;Init:
 ;--- start imported block

replaceinitcode

 ;--- end imported block
 rts 
;--------------------------
;--------------------------end init section

;-----------------------------------------------------------

;---- ASDK C64 getbitstatus function set (4) conversions,
;---- doublebufferupdate,findspritexyfromvirtualworldpixel,VirtualWorldPositionNotInCameraView getbitstatus
;----------------------  ---------------------------------  ---------------------------------- ------------


;-------------------------------------------------------------------------------------
 ;----GetBitStatus (subroutine/function) gets or sets bit status; accumulator passes the argument
 ; vars a and b used as temp vars; initially used the stack (preferred) but
 ; revised on debugging and never pushed it back ;)
 ;REVISED BELOW: (so vars a and b will be overwritten if you use them in your code)
 ;20220507 Correction, ispixelincamera puts tilepixel y in c
 ;                                          what is tilepixel x?
;-------------------------------------------------------------------------------------
GetBitStatus; duplicate label c alt spelling?
getbitstatus
;-------------------------------------------------------------------------------------
 ; ... this should be a dual get/set routine.
; arguments passed via the accumulator (lda #arg [0,1,2])
; always do this... lda #0 to flip the target bit via inversion, will clear or set it.
; lda #1 for setting it, also returns it's prior state in the accumulator, 0 if it was previously off
; lda #2 for polling - just returns the bits status
  ;20131127 yes you can...; sty a;20131031 now in bank2; can't pass accumulator when bankswitching so using y!


  sta a ; keep get/set flag that was passed in the accumulator

  cmp #2
  beq skipdoublebufferupdate ; 20140123 bugfix, polled pixels ghosting in playfield buffer (shouldn't be set anywhere)



 ;-- 20130410 Now that the primary kernel can be disengaged,
 ;-- pixels set on the large virtual world must also be set on the
 ;-- second display buffer (playfield buffer in zero page) whenever they overlap the CAM coordinates
 ;-- (otherwise they won't appear until you scroll)
 jsr ispixelincamera
 cmp #10

 beq skipdoublebufferupdate
 sty c ; c now holds y value for playfield buffer update

 ;doublebuffer update:
 jsr doublebufferupdate 

skipdoublebufferupdate 

;---20131127 getbitstatus rewrite for size and perf (need it for SuperCharger framework fit)
; lda #0
 ldx bity

 lda fastyindex,x ; 20140203 best opt; using a 20 byte lookup table!

;ad01 beq nobyterowoffset        ; loadbalancing opt2 20140131
;     cpx #5
;     bcc ad0a
;     clc
;     adc #60
;     dex
;     dex
;     dex
;     dex
;     dex
;     jmp ad01



;ad0 beq nobyterowoffset        ; loadbalancing opt
;ad0a     cpx #2
;     bcc ad1
;     clc
;     adc #24
;     dex
;     dex
;     jmp ad0
;ad1
; clc
; adc #12
; dex
; bne ad1

nobyterowoffset
 tax
 lda bitx
 clc
 adc #4; opt: bit 0-bit92 = bit4-96

 ; find bitx byte offset, remaninder is the target bit:
 ; can optimise this further too! What is it doing?
 ; looks like / 8; 40 goes in 5 goes out... 
 ; replace with lsr lsr lsr, need the remainder too
 ; 42 goes in 5 r2 comes out, 5 is added to x, r2 in a
 ; 00101010   no +1, carry is clear
 ; 00010101   +2, carry set
 ; 00001010   no +4 carry clear
;----------
 ; 00000101 5 r2

 ; 44 goes in r4 cones out, 5 is added to x, r4 in a
 ; 00101100 no +1  carry clear
 ; 00010110 no +2  carry clear
 ; 00001011 +4 carry set
;----------
 ; 00000101  5 r4
 ; 47 goes in 5 r7 comes out...

 ldy #0
 lsr
 bcc skipr1
 iny
skipr1
 lsr
 bcc skipr2
 iny
 iny
skipr2
 lsr
 bcc skipr4
 iny
 iny
 iny
 iny
skipr4
 
 sta b
 txa
 clc
 adc b 
 tax ; /8 value added to x
 tya ; remainder in a

;;ad3 cmp   #32;#24    ; load balancing opt     ; 20140131 pass2, 32 works better
;;    bcc ad2
;;    inx;
;;    inx
;;    inx
;;    inx
;;    sec
;;    sbc #32;#24
;;    jmp ad3

;;ad2 cmp #8
;;    bcc havebit
;;    inx
;;    sec
;;    sbc #8
;;    jmp ad2

havebit
 ldy ExtendedPlayfieldSCR,x ; read area of superchip/CBS RAM/ SuperCharger ROM/RAM

  ; reg x now has target byte to overwrite, accumulator has bitpointer
  ;-- only 8 handlers
  cmp #0
  bne notb0
  tya
  and #%10000000; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear0; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%10000000 ; set it
  cpy #0
  bne done0; branch always
clear0
  eor #%10000000 ; clear it
done0  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
  jmp donegetset
notb0;-----------------
  cmp #1
  bne notb1
  tya
  and #%01000000; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear1; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%01000000 ; set it
  cpy #0
  bne done1; branch always
clear1
  eor #%01000000 ; clear it
done1  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
  jmp donegetset
notb1;-----------------

  cmp #2
  bne notb2
  tya
  and #%00100000; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear2; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%00100000 ; set it
  cpy #0
  bne done2; branch always
clear2
  eor #%00100000 ; clear it
done2  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
  jmp donegetset
notb2;-----------------

  cmp #3
  bne notb3
  tya
  and #%00010000; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear3; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%00010000 ; set it
  cpy #0
  bne done3; branch always
clear3
  eor #%00010000 ; clear it
done3  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
  jmp donegetset
notb3;-----------------

  cmp #4
  bne notb4
  tya
  and #%00001000; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear4; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%00001000 ; set it
  cpy #0
  bne done4; branch always
clear4
  eor #%00001000 ; clear it
done4  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
  jmp donegetset
notb4;-----------------

  cmp #5
  bne notb5
  tya
  and #%00000100; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear5; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%00000100 ; set it
  cpy #0
  bne done5; branch always
clear5
  eor #%00000100 ; clear it
done5  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
  jmp donegetset
notb5;-----------------

  cmp #6
  bne notb6
  tya
  and #%00000010; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear6; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%00000010 ; set it
  cpy #0
  bne done6; branch always
clear6
  eor #%00000010 ; clear it
done6  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
  jmp donegetset
notb6;-----------------

 ; cmp #7
 ; bne notb7
  tya
  and #%00000001; was it set?
  sta b ; push previous bit status into temp var b
  tya
  ldy a
  beq clear7; get/set status is in var a, 0 flips bit, 1 always sets it
  ora #%00000001 ; set it
  cpy #0
  bne done7; branch always
clear7
  eor #%00000001 ; clear it
done7  ;sta ExtendedPlayfieldSCW,x ; store in write area of SUPERCHIP
;  jmp donegetset
;notb7;-----------------
;fall through
;----------------end rewrite

donegetset
 ldy a
 cpy #2 ;20131130 adding getstatus option 2 (0 flip, 1 set, 2 getstatus only)
 bne continuesetorflip  ; (saves doing double 0 calls to poll status)
 ; 20140131 lda b not yet (sc doesn't allow a cmp#0 following lda to fall through)
 lda b
 rts
continuesetorflip 
   ;-- turn off write protect
  ;; ldy #%00011011;write protect off, still in bank2
  ;; cmp RAM,y
  ;; nop
  ;; cmp WRITEPROTECT_DEST_ADRS

   ;-- write value to RAM "ROM"
  ;; tay
  ;; cmp RAM,y ; prepare the value for the write
  ;; nop
  ;; cmp ExtendedPlayfieldSCR,x ; update Virtual World Pixel
   
  ; cpx #240; out of range?
  ; bcs c64skipplayfieldwrite
   sta ExtendedPlayfieldSCW,x; c64 direct write
   ;==============================================
c64skipplayfieldwrite
  ;; ldy #%00011001 ; still in bank2, write protect on
  ;; cmp RAM,y
  ;; nop
  ;; cmp WRITEPROTECT_DEST_ADRS


 ;20131031 doing the LDA b in the switchboard after bankswitching (can't pass accumulator)
 ;20131127 yes you can...
 ; 20140131 no, can't lda b yet (sc doesn't allow a cmp#0 following lda to fall through)

 lda b; pla ; return previous bit status
 rts ; getbitstatus -------------------------------


 ;----SetBitStatus (SCROLLOUT)
;setbitstatus
; nop ; not used, above routine handles both
; nop

;------------------END GETBITSTATUS/SETBITSTATUS -------------
;-------------------------------------------------------------

;--------------------------------------------------------
;-- double buffer update: 20130410
; ---20220504 C64 version should be rewritten using getbitstatus (straight bitmap) as model 
;------------------------
;-- this function piggybacks GetBitStatus whenever the playfield CAM
;-- overlaps the virtual world and bits are set there
;-- (otherwise set pixels would not show until you scroll and engage the primary kernel)
;--------------------------------------------------------
doublebufferupdate
 ; lda #3
 ;sta COLUBK ; DEBUG
 ; rts

 ; d,c temp vars hold target x,y for localised playfield pixel:
 ; They are set whenever a pixel is set or flipped and can be
 ; used to map sprite movement to virtual world movement (clear them first)

 ;get argument:
;;20160525 superfluous ldx a ; 1 = set pixel, 0 = flip pixel

 ;20160525 - opt, now using 6 RAMplayfield  buffers, ... RAMplayfield5
 ; can remove playfieldlookup table? check for other references...
 ; must calc differently, y must still point to target byte:

 ;;20160525 ldx c
 ;;20160525 ldy playfieldlookup,x
 ;; y=(d/3)*10+c ...ok reuse thelookup table so x shows the target table (it's not used elsewhere)

;;20220507 revision for c64 4 VIC-II screen quadrants, testing 1st 1 first:
 
;;; ldy d
;;; lda playfieldlookup,y ; get target table (now there 6)
;;; clc
;;; adc c ; add y index to target table
;;; tay

 ldx d
 lda c64playfieldlookupxoffset,x ; get x*2 lookup 20 cols to 40
 sta b
 


 ldy c ; grab y value 
 lda c64playfieldlookup,y 
; y reg now has offset for playfieldbuffer target row (y value)

 clc
 ; 20220507 make sure b is not reused

 adc b; add the x value to get to the target byte
 tay ;put target byte in y


 ; don't need bitpos when calculating a byte ;) lo
 ;;;;ldy d ; get x value
 
 ;;;;lda c64playfieldlookupbitposx, y;find target bitpos
 ;;;;tay ; y now holds bitpos, x holds target byte in quadrant

 ; --- 20220507 mirror routine for 8 handlers ea q
 ; a dictates flip (beq) or set (bne), add that next now default flip

 ; (add branch to set)
  lda c
  cmp #3 ;  -------------c still has Display List row:
  bcs notVICII_Q1
  lda Tile1Char; 
  ldx a
  bne throw_quad_tile; set pixel
  cmp DisplayList0,y ; flip pixel?
  beq bgtilenxy0
throw_quad_tile
  sta DisplayList0,y
  lda Tile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList0,y+1
  lda Tile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList0Shadow,y  
  lda Tile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList0Shadow,y+1
  rts
bgtilenxy0 ; place background tile
throw_background_tile
  lda bTile1Char 
  sta DisplayList0,y
  lda bTile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList0,y+1
  lda bTile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList0Shadow,y  
  lda bTile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList0Shadow,y+1
  rts
  
notVICII_Q1  cmp #6 ; *Display list below the 1st three Display list rows.
  bcs notVICII_Q2

  lda Tile1Char; 
  ldx a
  bne throw_quad_tile1; set pixel
  cmp DisplayList1,y ; flip pixel?
  beq bgtilenxy1
throw_quad_tile1
  sta DisplayList1,y
  lda Tile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList1,y+1
  lda Tile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList1Shadow,y  
  lda Tile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList1Shadow,y+1
  rts
bgtilenxy1 ; place background tile
throw_background_tile1
  lda bTile1Char 
  sta DisplayList1,y
  lda bTile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList1,y+1
  lda bTile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList1Shadow,y  
  lda bTile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList1Shadow,y+1
  rts
  
notVICII_Q2  cmp #9 ; *Display list below the 1st three Display list rows.
  bcs notVICII_Q3


  lda Tile1Char; 
  ldx a
  bne throw_quad_tile2; set pixel
  cmp DisplayList2,y ; flip pixel?
  beq bgtilenxy2
throw_quad_tile2
  sta DisplayList2,y
  lda Tile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList2,y+1
  lda Tile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList2Shadow,y  
  lda Tile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList2Shadow,y+1
  rts
bgtilenxy2 ; place background tile
throw_background_tile2
  lda bTile1Char 
  sta DisplayList2,y
  lda bTile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList2,y+1
  lda bTile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList2Shadow,y  
  lda bTile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList2Shadow,y+1
  rts
  
notVICII_Q3 ; NOTHING TO COMPARE HAS TO BE ROW 9
 ; cmp #10 ; only 1 row in Q3 do not overwrite!          ------ 20220522 buffer overflow fix is superfluous fix
 ; bcs skipdoublebufferupdateoutofrange
  lda Tile1Char; 
  ldx a
  bne throw_quad_tile3; set pixel
  cmp DisplayList3,y ; flip pixel?
  beq bgtilenxy3
throw_quad_tile3
  sta DisplayList3,y
  lda Tile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList3,y+1
  lda Tile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList3Shadow,y  
  lda Tile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList3Shadow,y+1
  rts
bgtilenxy3 ; place background tile
throw_background_tile3
  lda bTile1Char 
  sta DisplayList3,y
  lda bTile2Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList3,y+1
  lda bTile3Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList3Shadow,y  
  lda bTile4Char; fetch next tile quadrant PETSCII graphic 
  sta DisplayList3Shadow,y+1
skipdoublebufferupdateoutofrange  
  rts

 

 rts; --kickout early debugging 20220507
 ;superflous... delete this:
 




;------------------------------------------------------
;-----end double buffer update 20220507 C64 optimized (perf inc)


;--------------------------------------------------------
findspritexyfromvirtualworldpixel
;--------------------------------------------------------
;-- inputs bitx, bity
;-- outputs temp var d,c
;--------------------------------------------------------

; lda bitx
; sec
; sbc BITIndex
; cmp #20
; bcs VirtualWorldPositionNotInCameraView
; sta d ; d now holds x position value in visible playfield 

 ; is bity also within the playfield buffer?
; ldy #0
; lda BYTErowoffset
;calcVWyopt1 cmp #36
 ;bcc donecalcVWyopt1
 ;sec
 ;sbc #36
 ;iny
 ;iny
 ;iny
 ;bne calcVWyopt1

;donecalcVWyopt1

;calcVWy1 cmp #0
; beq donecalcVWy1
; sec
; sbc #12
; iny ; 
; bvc calcVWy1 ; branch usually
 ;jmp calcVWy1
;donecalcVWy1
; sty c
; lda bity
; sec
 ;-- and here... the above 30 bytes of code are used twice (should sub, save 25 bytes... l8r)
; sbc c
 jsr ispixelincamera; reusing shared routine instead of duplicating it above, saves some more space.
 cmp #10
 beq VirtualWorldPositionNotInCameraView
 sty c ; c now holds y position value in visible playfield
 
 ;now calculate x sprite coordinate for x pixel position:
 inc d
 lda d
 ;multiply by 8  - screen is 20 fat pixels wide for 160 fine pixels
 asl;x2
 asl;x2
 asl;x2 ...= x8
 sta d
 inc d
        
 ;now calculate y sprite coordinate for y pixel positon:
 ; tougher, sprite y counts down, pixel y counts up
 lda #9
 sec
 sbc c  ; now playfield y is inverted; screen is 10 phat pixels tall (0-9)

 ;replace x10 with 10 byte lookup ; can factor in the adjustments too:
 tay
 lda tenbytelookup,y
;; sta c
;; ; now calculate sprite y from it screen is 96 pixes so must multiply by 10
;; asl
;; asl
;; asl ; x8
;; clc
;; adc c ;...x9
;; adc c ;.. x10

 ;----------adjust (also handled in table)
;; sec
;; adc #5
;; cmp #60
;; bcs doneadjustpixels
;; adc #2
;; cmp #10
;; bcs doneadjustpixels
;; adc #2
;;doneadjustpixels

 sta c ; c now holds sprite y coordinate (inverted) that maps to the visible screen pixel
   rts
 ;jmp findspritexyfromvirtualworldpixelRETURN



VirtualWorldPositionNotInCameraView
 lda #0 ; clear sprite coordinates, nothing to display
 sta c
 sta d
 ;jmp findspritexyfromvirtualworldpixelRETURN
  rts



;--------------------------------------------------------
;--end findsprite coordinates from virtualworld position
;--------------------------------------------------------

;------------------------------------------------------
;-----end findspritexyfromvirtualworldpixel 20220515 C64 optimized (perf inc)

;findspritexyfromvirtualworldpixelRETURN
;20220515 find all jmps and delete this routine (superfluous on the C64)
; fix supercharger updates
   ;-- keep write protect on switch back to bank1 (we're still in bank 3)
   ;--
   ;ldy #%00001001
   ;cmp RAM,y
   ;nop
   ;cmp WRITEPROTECT_DEST_ADRS
  ; rts



;----------------------------
;-------------------------------------------------------------------------------------
;-- space saving optimisation: shared routine from getbitstatus,findspritexyfromvirtualworkpixel
ispixelincamera
;checks if target virtual world pixel is in the camera view (visible playfield)
; load acculuator with 11 and rts to kickout
; clv ;yes ; no

 ; is bitx also within the playfield buffer?
 lda bitx
 cmp BITIndex
 bcc kickout ; needed extra kickout 
 sec
 sbc BITIndex
 cmp #20
; bcs skipdoublebufferupdate
 bcc continuecheckpixelincam
kickout lda #10 ; kickout
 rts
continuecheckpixelincam
 sta d ; d now holds x position value in visible playfield; value for playfield buffer overlap

 ; is bity also within the playfield buffer?

 ;lda BYTErowoffset
 ;20140202 load balancing opt for lower screen roll
 ldy bity
;; lda BYTErowoffset
;; bne continuecheckpix
;; rts ; no offset adjustment necessary for bity
;;continuecheckpix

 lda BYTErowoffset
 bne notzerooffset
 cpy #10
 bcs kickout ; out of range
 rts ; y already has bitindex and it needs no offset
notzerooffset

 lda fastyindex,y
 cmp BYTErowoffset ; new needed kickout for y!
 bcc kickout  ; avoid negative
 bne cnchk
 ldy #0
 rts
cnchk
 sec
 sbc BYTErowoffset
 cmp #120;#108
 bcs kickout ; not in view   
 cmp #12
 bne noty48;12
 ldy #1
 rts

noty48
 cmp #60
 bne noty12
 ldy #5
 rts


noty12
 bcs noty60   ; load balance

 cmp #24
 bne noty24
 ldy #2
 rts
noty24
 cmp #36
 bne noty36
 ldy #3
 rts

noty36 ; opt: has to be 4
;;  - cmp #48
;;  - bne noty60;noty48
  ldy #4
  rts


noty60
 cmp #72
 bne noty72
 ldy #6
 rts

noty72
 cmp #84
 bne not84
 ldy #7
 rts

not84
 cmp #96
 bne not96
 ldy #8
 rts
not96
; has to be 108:
 ldy #9; #108
 rts ; opt 20140220; simpler load balancing...


;--------END ispixelincamera

;--------------------------------




;------------ASDK C64 end getbitstatus function set (4) conversions

;20160531 moving 20 byte fastyindex lookup table to bank2 (no longer available to basic)


;---------------------------------------------------------------------

;20160617 moving MusicData to bank2 (sytem bank) to free up to 256 bytes from bank3!




;sprites
;REPLACESPRITEDAT not here repeat insert fix 20220617

 ;-- End inline sprite library table
;------------------------------------

 ;20160617 moving MusicData to bank2 (sytem bank) to free up to 256 bytes from bank3!
 ; 20220522 page aligning music data for c64
;MusicData
;REPLACEMUSICDAT 20220617 double data fix [unused table was pasted here]

;---------------end inline music data----------

;----------inline music engine------------

musicengine
MusicEngine
;-------------------------------------------------------------
; Background Music Engine -------------------------
;-------------------------------------------------------------
PlayMusic
LPlayMusic



 ;-----------------------------------------------

;   pha ; push a
;   tya
;   pha ; push y

 ;jmp musicfinish ;fix timing? yes, reduce it!

   lda SUSTAINFORFRAMES
   bne waitnextnote 
   ;clear voice+4 regs -------------------------durationfx
   ldy reg4voice1
   dey
   sty SIDvoice1+4

   sta $d416; 7-bit highpass filter piggyback
;;;   sta SIDvoice3+4

   ldy reg4voice2
   dey
   sty SIDvoice2+4

;get next notes:
; - freeing e
;;   lda e
;;   cmp #1
;;   bne continuenote
;;   ldy MUSICINDEX
;;   iny
;;  ; iny ; this throws it off but sounds good
;; ;  lda #10
;; ; gets reset next,  sta SUSTAINFORFRAMES
;;   jmp skipnote

continuenote

   ldy MUSICINDEX

  lda MusicData,y ; Fx voice 0

;20221031 table based TIA SID Tracker transposed from Commodore BASIC 2.0 Prototype!
  tax
  lda SID5,x
  sta SIDvoice1+5
  ;;;sta SIDvoice3+5 ; piggyback3

  lda SID6,x
  sta SIDvoice1+6
  ;;;sta SIDvoice3+6 ; piggyback3

  lda SID4,x
  and #%11110111 ; 20241001 do NOT disable voice... make sure bit 3 is 0
  sta SIDvoice1+4
  ;;;sta SIDvoice3+4; piggyback3

  sta reg4voice1; preseve to dec 1...
;  dec reg4voice1


   iny

   lda MusicData,y ; frequency voice 0

 tax
 ; get frequency lo/hi
  lda SIDhi,x
  sta SIDvoice1+1
  ;;;sta SIDvoice3+1; piggyback3

  lda SIDlow,x
  sta SIDvoice1
  ;;;sta SIDvoice3;piggyback3

 iny
                   lda MusicData,y ; fx voice 1

  tax
  lda SID5,x
  sta SIDvoice2+5
  lda SID6,x
  sta SIDvoice2+6
  lda SID4,x
 ;freeze? only if both ands activated... timing issue 
  and #%11110111 ; 20241001 do NOT disable voice... make sure bit 3 is 0
  sta SIDvoice2+4
  sta reg4voice2; preseve to dec 1...
;opt do it after ldy above  
;dec reg4voice2 ; 20221104 fixed out of order synth bug, interesting fx unintended...

   iny

   lda MusicData,y ; frequency voice 1

 tax
 ; get frequency lo/hi
  lda SIDhi,x
  sta SIDvoice2+1
  lda SIDlow,x
  sta SIDvoice2


 iny
                   lda MusicData,y ; frames duration (alogirithm for volume and band pass...)
                   bne continuemusicengine ; 20221110 fixed tracker bug from update, 0 must reset index   
                   sta MUSICINDEX;reset music index  
                   rts 
continuemusicengine
  sta SUSTAINFORFRAMES
 ;;;;;; 20221031... check this  sta $d418 ; pound d418 volume register 0-4, occassionally hit
           ; the low pass filter too! ;)
                                                  
 ;---experimental;
 ; --- adjust collapse waveform delay [move this 4 more cycles delay timingto shape note, not enough perhaps?]

   
   iny ; point to next data line (for musical score) in the table
   sty MUSICINDEX

waitnextnote


   dec SUSTAINFORFRAMES ;decrement framedelay counter
 ;  lda SUSTAINFORFRAMES
  ; sta $d418; 20221031 --- should work to pound Dd418...

continuewaitnextnote

musicfinish   rts

 ;why nop?  10012024 
 ;nop
 ;nop
 ;balance

;-----------------------------------------

;----------END music engine --------------

renderplayer0

 ;debug
 ;lda #255
 ;sta 1025 ; upper 2nd char

 lda 53269
 ora #%00000001 ; make sprite 0 visible
 sta 53269

 lda player0colors ; ,0 get the 1st of 8 colors only...
 sta 53287 ; player 0 color
  ; player0 has the 8 rows loaded already (8x8 sprite)
 ;-- transfer to sprite 0:
; lda #5
 ;sta 53285;multicolor sprite extra color 1
 ;lda #7
; sta 53286 ;multicolor sprite extra color 2

; lda #201
; sta 2041 ; pointer?
 

 ;---;  12800 ; sprite 0 begin
 ldx #7
 ldy #0
 ;------------------------------------------------------------------
 ;----------------------------------------------------
;----; tripple scale sprite0?
 ;jmp donttripplescalesprite0 ;debug
 lda NUSIZ0
 ror; check tripple scale option
  bcc dontscalesprite0
 ror; check double scale option
  bcs dotripplescalesprite0; replace with doublescale  
dodoublescalesprite0
 lda REFP0
 and #%00001000
 bne drawdoublescaleplayer0backwards


drawdoublescaleplayer0
 stx a
 lda Sprite0SCR,x
  tax  
 lda doublescaletable1,x
 sta 12800,y
 iny
 lda doublescaletable2,x
 sta 12800,y
 iny
 lda #0;tripplescaletable3,x
 ;! iny
 sta 12800,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 dec a
 ldx a
 cpx #255
 bne drawdoublescaleplayer0 
 jmp player0position; 20220527 jump around reverse routine

;20220527 software solution for hardware reverse byte:
drawdoublescaleplayer0backwards 
 stx a
drawdoublescaleplayer0backwardsloop 
 lda Sprite0SCR,x ;------------- Draw sprite backwards:
 tax  ; now have reverse sprite table filter in x to lookup a reg
 lda REFP,x  ; now to apply tripple filter on the reverse filter:
 tax
 lda doublescaletable1,x
 sta 12800,y
 iny
 lda doublescaletable2,x
 sta 12800,y
 iny
 lda #0;tripplescaletable3,x
 ;! iny
 sta 12800,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 deC a
 ldx a
 cpx #255
 bne drawdoublescaleplayer0backwardsloop ;--------- flushed/fixed reverse player1 bug in main reverse branch too
 ; now would have to draw 3... sta 12864,y; draw the last one ; found last row bug on player1 20221024


;--------------------------------------------------------
;-- end double scale sprite0
 jmp player0position
  ;--- end double scale sprite0

dontscalesprite0 
  jmp donttripplescalesprite0  
  

dotripplescalesprite0
 lda REFP0
 and #%00001000
 bne drawtripplescaleplayer0backwards


drawtripplescaleplayer0
 stx a
 lda Sprite0SCR,x
  tax  
 lda tripplescaletable1,x
 sta 12800,y
 iny
 lda tripplescaletable2,x
 sta 12800,y
 iny
 lda tripplescaletable3,x
 ;! iny
 sta 12800,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 dec a
 ldx a
 cpx #255
 bne drawtripplescaleplayer0 
 jmp player0position; 20220527 jump around reverse routine

;20220527 software solution for hardware reverse byte:
drawtripplescaleplayer0backwards 
 stx a
drawtripplescaleplayer0backwardsloop 
 lda Sprite0SCR,x ;------------- Draw sprite backwards:
 tax  ; now have reverse sprite table filter in x to lookup a reg
 lda REFP,x  ; now to apply tripple filter on the reverse filter:
 tax
 lda tripplescaletable1,x
 sta 12800,y
 iny
 lda tripplescaletable2,x
 sta 12800,y
 iny
 lda tripplescaletable3,x
 ;! iny
 sta 12800,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 deC a
 ldx a
 cpx #255
 bne drawtripplescaleplayer0backwardsloop ;--------- flushed/fixed reverse player1 bug in main reverse branch too
 ; now would have to draw 3... sta 12864,y; draw the last one ; found last row bug on player1 20221024


;--------------------------------------------------------
;-- end tripple scale sprite0
 jmp player0position
donttripplescalesprite0




 ;--20220527 implementing reverse player0 using shadow reg lookup table:
 ;#%00001000
 lda REFP0
 and #%00001000
 bne drawplayer0backwards


drawplayer0  lda Sprite0SCR,x ;------------- Draw sprite forward:
 sta 12800,y
 iny
 lda #0
 sta 12800,y
 iny
 sta 12800,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 sta 12800,y
 dex
 cpx #255
 bne drawplayer0 ;----------------------------
 beq player0position; 20220527 jump around reverse routine

;20220527 software solution for hardware reverse byte:
drawplayer0backwards 
 stx a
drawplayer0backwardsloop 
 lda Sprite0SCR,x ;------------- Draw sprite backwards:
 tax 
 lda REFP,x 
 sta 12800,y
  iny
  lda #0
  sta 12800,y
  iny
  sta 12800,y
  iny ; jump to next row (8x8 sprite in 24x21 grid)
  sta 12800,y
 deC a
 ldx a
 cpx #255
 bne drawplayer0backwardsloop ;---------
 ;lda REFP,x
 ;sta 12800,y; draw the last one


player0position

;fixplayer0spritenoise ; why?
; sta 12800,y
; iny
; inx
; cpx #5
; bne fixplayer0spritenoise

 ;--- position:
 ldy player0x
 ; Is MSB bit 8 set? (X pos value >255 to half) 
 cpy #128
 bcs setMSBsprite0
clearMSBsprite0
 lda 53264
 and #%11111110
 sta 53264
 bcc doneMSBsprite0

setMSBsprite0
 lda 53264
 ora #%00000001
 sta 53264
doneMSBsprite0   

 lda Atari2600C64HorizontalPositioningMap,y 
 sta 53248 ; player 0x

 ldy player0y
 lda Atari2600C64VertialPositioningMap,y
 sta 53249; player0y pos
 rts ;---------------------------end renderplayer0

renderplayer1

 ;debug
 ;lda #254
 ;sta 1027 ; upper 2nd char

 lda 53269
 ora #%00000010 ; make sprite 1 visible
 sta 53269

 lda COLUP1 ; get C64 Atari 2600 shadow register for solid player1
 sta 53288 ; player 1 color
 
;----------------------------------------------------
 ;---;  12864 ; sprite 1 begin
 ldx #7
 ldy #0
;----------------------------------------------------
;----; scaling options, double or tripple scale sprite1?
 lda NUSIZ1
 ror; check scaling options
  bcc donotscalesprite1    ; bcs dotripplescalesprite1
 ror; check double scale option
  bcs dotripplescalesprite1; replace with doublescale  
;----double scale sprite1
dodoublescalesprite1;-----------------------------------
 lda REFP1
 and #%00001000
 bne drawdoublescaleplayer1backwards


drawdoublescaleplayer1  
 stx a
 lda Sprite1SCR,x
  tax  
 lda doublescaletable1,x
 sta 12864,y
 iny
 lda doublescaletable2,x
 sta 12864,y
 iny
 lda #0; tripplescaletable3,x
 sta 12864,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 dec a
 ldx a
 cpx #255
 bne drawdoublescaleplayer1 
 jmp player1position; 20220527 jump around reverse routine

;20220527 software solution for hardware reverse byte:
drawdoublescaleplayer1backwards 
 stx a
drawdoublescaleplayer1backwardsloop 
 lda Sprite1SCR,x ;------------- Draw sprite backwards:
 tax  ; now have reverse sprite table filter in x to lookup a reg
 lda REFP,x  ; now to apply tripple filter on the reverse filter:
 tax
 lda doublescaletable1,x
 sta 12864,y
 iny
 lda doublescaletable2,x
 sta 12864,y
 iny
 lda #0;tripplescaletable3,x
 ;! iny
 sta 12864,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 deC a
 ldx a
 cpx #255
 bne drawdoublescaleplayer1backwardsloop ;--------- flushed/fixed reverse player1 bug in main reverse branch too
 ; now would have to draw 3... sta 12864,y; draw the last one ; found last row bug on player1 20221024


;--------------------------------------------------------
 jmp player1position


;-- end double scale sprite1
;-------------------------------------------------


donotscalesprite1   
  jmp donttripplescalesprite1  
  

dotripplescalesprite1
 lda REFP1
 and #%00001000
 bne drawtripplescaleplayer1backwards


drawtripplescaleplayer1  
 stx a
 lda Sprite1SCR,x
  tax  
 lda tripplescaletable1,x
 sta 12864,y
 iny
 lda tripplescaletable2,x
 sta 12864,y
 iny
 lda tripplescaletable3,x
 sta 12864,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 dec a
 ldx a
 cpx #255
 bne drawtripplescaleplayer1 
 jmp player1position; 20220527 jump around reverse routine

;20220527 software solution for hardware reverse byte:
drawtripplescaleplayer1backwards 
 stx a
drawtripplescaleplayer1backwardsloop 
 lda Sprite1SCR,x ;------------- Draw sprite backwards:
 tax  ; now have reverse sprite table filter in x to lookup a reg
 lda REFP,x  ; now to apply tripple filter on the reverse filter:
 tax
 lda tripplescaletable1,x
 sta 12864,y
 iny
 lda tripplescaletable2,x
 sta 12864,y
 iny
 lda tripplescaletable3,x
 ;! iny
 sta 12864,y
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 deC a
 ldx a
 cpx #255
 bne drawtripplescaleplayer1backwardsloop ;--------- flushed/fixed reverse player1 bug in main reverse branch too
 ; now would have to draw 3... sta 12864,y; draw the last one ; found last row bug on player1 20221024


;--------------------------------------------------------
;-- end tripple scale sprite1
 jmp player1position
donttripplescalesprite1

;----------------------------------------------------
;---single scale sprite 1
 ;--20220527 implementing reverse player1 using shadow reg lookup table:
 ;#%00001000
 lda REFP1
 and #%00001000
 bne drawplayer1backwards


drawplayer1  lda Sprite1SCR,x
 sta 12864,y
 lda #0
 iny
 sta 12864,y; clear possible double scale
 iny
 sta 12864,y; clear possible tripple scale
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 dex
 cpx #255
 bne drawplayer1 

;fixplayer1spritenoise ; why?
; sta 12864,y
; iny
; inx
; cpx #5
; bne fixplayer1spritenoise

 jmp player1position; 20220527 jump around reverse routine
 

;20220527 software solution for hardware reverse byte:
drawplayer1backwards 
 stx a
drawplayer1backwardsloop 
 lda Sprite1SCR,x ;------------- Draw sprite backwards:
 tax 
 lda REFP,x 
 sta 12864,y
 lda #0
 iny
 sta 12864,y ; clear possible double scale
 iny
 sta 12864,y ; clear possible tripple scale
 iny ; jump to next row (8x8 sprite in 24x21 grid)
 deC a
 ldx a
 cpx #255
 bne drawplayer1backwardsloop ;--------- 20221024 fixed bad branch drawing backwards player1!


 ;--- position: [shared routine]
player1position





  ;--- position:
 ldy player1x
 ; Is MSB bit 8 set? (X pos value >255 to half) 
 cpy #128
 bcs setMSBsprite1
clearMSBsprite1
 lda 53264
 and #%11111101
 sta 53264
 bcc doneMSBsprite1

setMSBsprite1
 lda 53264
 ora #%00000010
 sta 53264
doneMSBsprite1   

 lda Atari2600C64HorizontalPositioningMap,y
 sta 53250 ; player 1x

 ldy player1y
 lda Atari2600C64VertialPositioningMap,y

 sta 53251; player1y pos
 rts ;-------------end renderplayer1

;-----------------------------------------------------------------
rendermissle0
;-----------------------------------------------------------------

;----------------------------------
 ;debug
 ;lda #254
 ;sta 1027 ; upper 2nd char

 lda 53269
 ora #%00000100 ; make sprite 2 (as missile0) visible
 sta 53269

 lda player0colors+1;COLUP1 ; get C64 Atari 2600 shadow register for solid player1
 ; grab 2nd player0 color from color array for the missle color
 sta 53289 ; sprite 3 (as missle0) color
 
;----------------------------------------------------
 ;---;  12928 ; sprite 2 begin
; ldx #7
; ldy #0
drawmissile0  lda missile0;#%00011000 ;missle0 pattern, this should use a low ram VAR 
;                           ; TODO:shape pattern based on atari2600 missle size register
 sta 12928+6;,y
 sta 12928+9;two deep 
; iny
; iny
; iny ; jump to next row (8x8 sprite in 24x21 grid)
; dex
; cpx #255
; bne drawplayer1 
 ;--- position:
  ;--- position:
 ldy missile0x
 ; Is MSB bit 8 set? (X pos value >255 to half) 
 cpy #128
 bcs setMSBspritem0
clearMSBspritem0
 lda 53264
 and #%11111011
 sta 53264
 bcc doneMSBspritem0

setMSBspritem0
 lda 53264
 ora #%00000100
 sta 53264
doneMSBspritem0   

 lda Atari2600C64HorizontalPositioningMap,y
 sta 53252 ; sprite 2 x (as missile0x)

 ldy missile0y
 lda Atari2600C64VertialPositioningMap,y

 sta 53253; sprite 2 y pos (as missile0y)


;-----------------------------------------------------------------
 rts ;-----------------end rendermissle0
;-----------------------------------------------------------------

;-----------------------------------------------------------------
rendermissle1 
;-----------------------------------------------------------------
;----------------------------------
 ;debug
 ;lda #254
 ;sta 1027 ; upper 2nd char

 lda 53269
 ora #%00001000 ; make sprite 3 (as missile1) visible
 sta 53269
 
 lda player0colors+4;COLUP1  get C64 Atari 2600 shadow register for solid player1
; lda COLUP1; now colup1  get C64 Atari 2600 shadow register for solid player1
 ; grab 3rd player0 color from player 0 color array for the 2nd missle color
 sta 53290 ; sprite 3 (as missle1) color
 
;----------------------------------------------------
 ;---;  12992 ; sprite 3 begin
; ldx #7
; ldy #0
drawmissile1  lda missile1;#%00011000 ;missle0 pattern, this should use a low ram VAR 
;                           ; TODO:shape pattern based on atari2600 missle size register
 sta 12992+6;,y
 sta 12992+9;two deep 
; iny
; iny
; iny ; jump to next row (8x8 sprite in 24x21 grid)
; dex
; cpx #255
; bne drawplayer1 
 ;--- position:
  ;--- position:
 ldy missile1x
 ; Is MSB bit 8 set? (X pos value >255 to half) 
 cpy #128
 bcs setMSBspritem1
clearMSBspritem1
 lda 53264
 and #%11110111
 sta 53264
 bcc doneMSBspritem1

setMSBspritem1
 lda 53264
 ora #%00001000
 sta 53264
doneMSBspritem1   

 lda Atari2600C64HorizontalPositioningMap,y
 sta 53254 ; sprite 3 x (as missile1x)

 ldy missile1y
 lda Atari2600C64VertialPositioningMap,y

 sta 53255; sprite 3 y pos (as missile1y)


 rts ;-----------------end rendermissle1
;-----------------------------------------------------------------




loadplayer;BANK2
;------------------------------------
; arguments: registers a,y
; A (0,1) player0, player1
; Y (set argument to 0/8/16/24/etc to load image 1/2/3/4)
; (target image is loaded upside down into high RAM)
;------------------------------------
;20220516 Piggybacking C64 staggered sprite bufferload with image copy
;how to resolve updates to the 8x8 buffer then?? hook raisevent!  
; also move sprite pointer inits to init section so it doesn't run every frame...
;

 ldx #7
 sta c
 sty d
PushSprite0toCBSRAM lda SPRITEDATA,y ; get 1st byte of selected sprite from ROM image library
  
 
 ldy c
 bne updatesprite1 ;20140121 had it backwards


 sta Sprite0SCR,x
 jmp doneupdatesprite
updatesprite1
 sta Sprite1SCR,x

doneupdatesprite

 inc d
 ldy d
 
 dex
 bpl PushSprite0toCBSRAM
 rts
;--- END LOADPLAYER:

;LOADPLAYERUPSIDEDOWN:

;-------------------------------
loadplayerupsidedown
;------------------------------------
; arguments: registers a,y
; A (0,1) player0, player1
; Y (set argument to 0/8/16/24/etc to load image 1/2/3/4)
; (target image is loaded upside down into high RAM)
;------------------------------------
;20220516 Piggybacking C64 staggered sprite bufferload with image copy
;how to resolve updates to the 8x8 buffer then?? hook raisevent!  
; also move sprite pointer inits to init section so it doesn't run every frame...
;

 ldx #0
 sta c
 sty d
PushSprite0toCBSRAM1 lda SPRITEDATA,y ; get 1st byte of selected sprite from ROM image library
  
 
 ldy c
 bne updatesprite1a ;20140121 had it backwards


 sta Sprite0SCR,x
 jmp doneupdatesprite1
updatesprite1a
 sta Sprite1SCR,x

doneupdatesprite1

 inc d
 ldy d
 
 inx
 cpx #8
 bcc PushSprite0toCBSRAM1
 rts
;--- END LOADPLAYER:


;end loadplayerupsidedown
;--------------------------------




clearuptheirq
;// Turn off interrupts from the two CIA chips.
 ;   // Used by the kernal to flash cursor and scan 
  ;  // keyboard.
   ; //
    lda #$7f
    sta $dc0d ;//Turn off CIA 1 interrupts
    sta $dd0d ;//Turn off CIA 2 interrupts

    ;//
    ;// Reading these registers we ack any pending CIA interrupts.
    ;// Otherwise, we might get a trailing interrupt after setup.
    ;//
    lda $dc0d
    lda $dd0d

   ; 20230119 NMI was searching for an NTSC only raster interrupt disallowing PAL systems...
       ; checking if perf matches on NTSC without the NMI...

    ;//
    ;// Tell VIC-II to start generating raster interrupts
    ;//
; PAL ISSUE                lda #$01   
; PAL ISSUE             sta $d01a ;//Turn on raster interrupts
               ; TODO: add row colors from raster 
;    //
 ;   // Bank out BASIC and KERNAL.
  ;  // This causes the CPU to see RAM instead of KERNAL and
   ; // BASIC ROM at $E000-$FFFF and $A000-$BFFF respectively.
    ;//
    ;// This causes the CPU to see RAM everywhere except for
  ;  // $D000-$E000, where the VIC-II, SID, CIA's etc are located.
   ; //
    
    ;20240110 left $00 setting out??
    ; $00 is aleady 2F by default so last 4 bits are all on allowing read/write to those 4 bits in $01
    ;;lda #%11111111 (not 00000000, that prevents corresponding bits in 01 from being revised) 
    ;;sta $00 ; allow $01 to be revised
    
    lda #$35
    sta $01


    ;//
    ;// Create a nop, irq handler for NMI that gets called whenever
    ;// RESTORE is pressed or similar.
  ;  //
   ; // We're putting our irq handler directly in the vector that
    ;// usually points to the kernal's NMI handler since we have
  ;  // kernal banked out.
   ; //
; PAL ISSUE      lda #<nmi_nop
; PAL ISSUE    sta $fffa
; PAL ISSUE    lda #>nmi_nop
; PAL ISSUE    sta $fffb

 ;   //
  ;  // Force an NMI by setting up a timer. This will cause an NMI, that won't
  ;  // be acked. Any subsequent NMI's from RESTORE will be essentially
  ;  // disabled.


; -  superfluous:
; PAL ISSUE  
 lda #$00
; PAL ISSUE  
  sta $dd0e    ;   // Stop timer A
 rts

 	
nmi_nop:
  ;  //
  ;  // This is the irq handler for the NMI. Just returns without acknowledge.
  ;  // This prevents subsequent NMI's from interfering.
   ; //
    rti
Lloadvirtualworld 
 ldx #239
 ;stx COLUBK
 ldy a ; get virtualworld target
loadvirtualworldloop ;-- add multiple handlers to load multiple worlds (can fit them now in the extra ROM bank)
 cpy #1
 beq getvirtualworld2
 lda GameScreenBitmap,x
 jmp donewithgetvirtualworld
getvirtualworld2 lda GameScreenBitmap+240,x 
donewithgetvirtualworld 
 sta ExtendedPlayfieldSCW,x
 dex
 bne loadvirtualworldloop
 sta ExtendedPlayfieldSCW,x; missed last one

 rts ;legacy - now implementing Atari Flashback Abstract Assembly and BASIC intrinsic 202230814
 
;;;;! org 19968; page aligned 1st and 2nd virtual world tables (copy of 1st) [Atari Flashback compatibility] 
 ; 32 bytes free space at end of 2nd virtualworld table
GameScreenBitmap ; contiguous, 2 240 byte words, 2nd is not page aligned [OK]
ReplaceGameScreenBitmap
xxxLACEExtendedPlayfieldSCR ; see bug fix 20230815; previously req comment out bitmap below when activating replace or 240 bytes memory will be wasted

; this is a ROM image only for CBS RAM version, gets pushed into ExtendedPlayfield write/read addresses


 org 20480;page align sprites test leaving dummy in place
sprites
REPLACESPRITEDATA

 org 20736
 ;C64 page aligned reverse bit table=[Atari HARDWARE sprite reflection]
REFP; REFPO and REFP1 bit mirror table when REFP0/REFP1 D3 = 1  [#%00001000]
 .byte #%00000000
 .byte #%10000000
 .byte #%01000000
 .byte #%11000000
 .byte #%00100000
 .byte #%10100000
 .byte #%01100000
 .byte #%11100000
 .byte #%00010000
 .byte #%10010000

 .byte #%01010000
 .byte #%11010000
 .byte #%00110000
 .byte #%10110000
 .byte #%01110000
 .byte #%11110000
 .byte #%00001000
 .byte #%10001000
 .byte #%01001000
 .byte #%11001000

 .byte #%00101000
 .byte #%10101000
 .byte #%01101000
 .byte #%11101000
 .byte #%00011000
 .byte #%10011000
 .byte #%01011000
 .byte #%11011000
 .byte #%00111000
 .byte #%10111000
 ;30
 .byte #%01111000
 .byte #%11111000
 .byte #%00000100
 .byte #%10000100
 .byte #%01000100
 .byte #%11000100
 .byte #%00100100
 .byte #%10100100
 .byte #%01100100
 .byte #%11100100
 .byte #%00010100
 .byte #%10010100
 .byte #%01010100
 .byte #%11010100
 .byte #%00110100
 .byte #%10110100
 .byte #%01110100
 .byte #%11110100
 .byte #%00001100
 .byte #%10001100
 ;50
 
 .byte #%01001100
 .byte #%11001100
 .byte #%00101100 ; 52
 .byte #%10101100
 .byte #%01101100
 .byte #%11101100
 .byte #%00011100; 56
 .byte #%10011100
 .byte #%01011100
 .byte #%11011100
  ;60
 .byte #%00111100
 .byte #%10111100
 .byte #%01111100
 .byte #%11111100
 .byte #%00000010
 .byte #%10000010
 .byte #%01000010
 .byte #%11000010
 .byte #%00100010
 .byte #%10100010
  ;70
 .byte #%01100010
 .byte #%11100010
 .byte #%00010010
 .byte #%10010010
 .byte #%01010010; 74
 .byte #%11010010
 .byte #%00110010
 .byte #%10110010 ; 77
 .byte #%01110010
 .byte #%11110010
  ;80
 .byte #%00001010
 .byte #%10001010
 .byte #%01001010
 .byte #%11001010
 .byte #%00101010
 .byte #%10101010
 .byte #%01101010
 .byte #%11101010
 .byte #%00011010
 .byte #%10011010
  ;90
 .byte #%01011010
 .byte #%11011010
 .byte #%00111010
 .byte #%10111010
 .byte #%01111010
 .byte #%11111010
 .byte #%00000110
 .byte #%10000110
 .byte #%01000110
 .byte #%11000110
  ;100
 .byte #%00100110
 .byte #%10100110
 .byte #%01100110
 .byte #%11100110
 .byte #%00010110
 .byte #%10010110
 .byte #%01010110
 .byte #%11010110
 .byte #%00110110
 .byte #%10110110
 ;110
 .byte #%01110110
 .byte #%11110110
 .byte #%00001110
 .byte #%10001110
 .byte #%01001110
 .byte #%11001110
 .byte #%00101110
 .byte #%10101110
 .byte #%01101110
 .byte #%11101110
 ;120
 .byte #%00011110
 .byte #%10011110
 .byte #%01011110
 .byte #%11011110
 .byte #%00111110
 .byte #%10111110
 .byte #%01111110
 .byte #%11111110
 .byte #%00000001
 .byte #%10000001
 ;130
 .byte #%01000001
 .byte #%11000001
 .byte #%00100001
 .byte #%10100001
 .byte #%01100001
 .byte #%11100001
 .byte #%00010001
 .byte #%10010001
 .byte #%01010001
 .byte #%11010001
  ;140
 .byte #%00110001
 .byte #%10110001
 .byte #%01110001
 .byte #%11110001
 .byte #%00001001
 .byte #%10001001
 .byte #%01001001
 .byte #%11001001
 .byte #%00101001
 .byte #%10101001
  ;150
 .byte #%01101001
 .byte #%11101001
 .byte #%00011001
 .byte #%10011001
 .byte #%01011001
 .byte #%11011001
 .byte #%00111001
 .byte #%10111001
 .byte #%01111001
 .byte #%11111001
  ;160
 .byte #%00000101
 .byte #%10000101
 .byte #%01000101
 .byte #%11000101
 .byte #%00100101
 .byte #%10100101
 .byte #%01100101
 .byte #%11100101
 .byte #%00010101
 .byte #%10010101
 ; 170
 .byte #%01010101
 .byte #%11010101
 .byte #%00110101
 .byte #%10110101
 .byte #%01110101
 .byte #%11110101
 .byte #%00001101
 .byte #%10001101
 .byte #%01001101
 .byte #%11001101
 ;180
 .byte #%00101101
 .byte #%10101101
 .byte #%01101101
 .byte #%11101101
 .byte #%00011101
 .byte #%10011101
 .byte #%01011101
 .byte #%11011101
 .byte #%00111101
 .byte #%10111101
 ;190
 .byte #%01111101
 .byte #%11111101
 .byte #%00000011;192
 .byte #%10000011
 .byte #%01000011
 .byte #%11000011
 .byte #%00100011
 .byte #%10100011
 .byte #%01100011
 .byte #%11100011
 ;200
 .byte #%00010011
 .byte #%10010011
 .byte #%01010011
 .byte #%11010011
 .byte #%00110011
 .byte #%10110011
 .byte #%01110011
 .byte #%11110011
 .byte #%00001011
 .byte #%10001011
 ;210 ; ok checkpoint
 .byte #%01001011
 .byte #%11001011
 .byte #%00101011
 .byte #%10101011
 .byte #%01101011
 .byte #%11101011
 .byte #%00011011
 .byte #%10011011
 .byte #%01011011
 .byte #%11011011
 ;220 checkpoint
 .byte #%00111011
 .byte #%10111011
 .byte #%01111011
 .byte #%11111011
 .byte #%00000111
 .byte #%10000111
 .byte #%01000111
 .byte #%11000111
 .byte #%00100111
 .byte #%10100111
;230 checkpoint
 .byte #%01100111
 .byte #%11100111
 .byte #%00010111 ; 232
 .byte #%10010111
 .byte #%01010111
 .byte #%11010111
 .byte #%00110111
 .byte #%10110111
 .byte #%01110111
 .byte #%11110111
 ; 240
 .byte #%00001111
 .byte #%10001111
 .byte #%01001111
 .byte #%11001111
 .byte #%00101111
 .byte #%10101111
 .byte #%01101111
 .byte #%11101111
 .byte #%00011111
 .byte #%10011111
 ; 250
 .byte #%01011111
 .byte #%11011111
 .byte #%00111111
 .byte #%10111111
 .byte #%01111111
 .byte #%11111111 ; 255 is a palendrome like 00000000

 ;-------end hardware sprite reflection table

; --- no space here!
   
 org 20992; page align chiptune; cannot leave dummy in place
 ;256 bytes page aligned here free space after music table!

MusicData
REPLACEMUSICDATA


 ;512 bytes free space page aligned here for small lookup tables;
 ; SID tablespace 20221031
;-------------------------------------
;------------------------------------------------------
;-SID ADSR SIDvoicex+5,SIDvoicex+6,SIDvoicex+4 ARRAYS--
;------------------------------------------------------

;TIA TONE TO SID FREQUENCY MAP;

SIDhi .byte 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2 ,2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 8, 8, 9


SIDlow
 .byte 18,35,52,70,90,110,132,140
 .byte 179,205,229,6,37,69,104,131,179
 .byte 220,8,54,104,156,210,13,73,139
 .byte 208,25,103,185,10,108,206,53,163,23,147,21

;--20230408 SID now set for maximum resonance for filters in D417 (54295)

;--SID Instruments, choose  from 3 sets: (for SID4,SID5 ad SID6)

;-- these sound better
;SID5 .byte 9,9,8,8,88,88,88,88,144,88,144,88,9,9,8,8,88,88,9,9,9,8,8,88,88,88,88,144,88,144,88,9,9,8,8,88,88,9
;SID6 .byte 0,0,0,0,195,195,7,9,243,9,243,9,9,9,9,0,195,195,9,0,0,0,0,195,195,7,9,243,9,243,9,9,9,9,0,195,195,9
;SID4 .byte 33,17,65,49,33,23,33,33,17,33,129,33,33,17,17,49,33,17,33,33,17,65,49,33,23,33,33,17,33,129,33,33,17,17,49,33,17,33

;--in case of overflow, extra sound styles repetitive:

;SID5 .byte 0,168,8,8,8,10,8,88,144,88,144,88,9,9,9,9,9,9, 9,9,9,9,9,9,9,9,9,9,9,9,9
;SID6 .byte 140,168,0,0,143,195,7,9,243,9,243,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9
;SID4 .byte 33,17,65,49,33,23,33,33,17,33,129,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33

;-- 20230120 tuning overflow settings [release values, test with filter max resonance setting 20230408 - not as good rolling back/commenting out]
SID5 .byte 0,168,8,8,8,10,8,88,144,88,144,88,9,0,168,8,8,8,10,8,88,144,88,144,88,9,9,9,10,9,9,9,9,10,168,88
SID6 .byte 140,168,0,0,143,195,7,9,243,9,243,9,140,168,0,0,143,195,7,9,243,9,243,99,243,9,9,168,9,9,9,9,9,9,7,143
SID4 .byte 33,17,65,49,49,23,33,33,17,33,129,33,33,17,65,49,33,23,33,33,17,33,129,33,49,33,33,65,33,33,33,33,33,33,33,17,33,129

;control reg SID4 d404/54276
; rem 3forms        01000110 70
;                   00100110 40 
;                   00010110 20
; add 1 for ad instead of sr
;--------------------------------


;20241007 test including instruments from inspiring SID programmers BASIC program...
;.... needs adjusting
;SID4 .byte  70,40,20,71,41,21,33,17,65,49,49,23,33,33,17,33,129,33,33,17,65,49,33,23,33,33,17,33,129,33,49,33,33,65,33,33,33,33,33,33,33,17,33,129
;SID5 .byte 144,88,144,88,9,88,10,168,8,8,8,10,8,88,144,88,144,88,9,88,168,8,8,8,10,8,88,144,88,144,88,9,9,9,10,9,9,9,9,10,168,88
;SID6 .byte 140,168,10,10,143,195,140,168,10,10,143,195,7,9,243,9,243,9,140,168,0,0,143,195,7,9,243,9,243,99,243,9,9,168,9,9,9,9,9,9,7,143





;--

;relocating reg4voice1 and reg4voice2 to immediate page to save cycles
;reg4voice1 .byte 0
;reg4voice2 .byte 0
;; deprecated reg4voice3 .byte 0


 
;--- data now at the end... possible page breaks
 org 21760; give 768 bytes above for page aligned chiptunes (x3 oversized)
           ; (minus SID tables, or 140 bytes)
;--------software Hardware scaling via 3x and 2x double tripple scale tables:
 ;note: 3 256 byte tripple scale lookup tables and 2 256 byte double scale tbls = 1.25k, leaves 2.75k for RAM Arrays...

;----Tripple scalling, 3 256 byte tables c shared index:
tripplescaletable1	
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011100
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%00011111
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100000
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11100011
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111

tripplescaletable2	
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00001110
 .byte #%00001110
 .byte #%00001110
 .byte #%00001110
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01111110
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00001110
 .byte #%00001110
 .byte #%00001110
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110001
 .byte #%01110001
 .byte #%01110001
 .byte #%01110001
 .byte #%01111110
 .byte #%01111110
 .byte #%01111110
 .byte #%01111110
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00001110
 .byte #%00001110
 .byte #%00001110
 .byte #%00001110
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110001
 .byte #%01110001
 .byte #%01110001
 .byte #%01110001
 .byte #%01111110
 .byte #%01111110
 .byte #%01111110
 .byte #%01111110
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00000001
 .byte #%00001110
 .byte #%00001110
 .byte #%00001110
 .byte #%00001110
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110000
 .byte #%01110001
 .byte #%01110001
 .byte #%01110001
 .byte #%01110001
 .byte #%01111110
 .byte #%01111110
 .byte #%01111110
 .byte #%01111110
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%01111111
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000000
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10000001
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001110
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%10001111
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11110001
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111110
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111

tripplescaletable3	
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111
 .byte #%00000000
 .byte #%00000111
 .byte #%00111000
 .byte #%00111111
 .byte #%11000000
 .byte #%11000111
 .byte #%11111000
 .byte #%11111111

;--- end tripple scaling hardware tables (3)


;---double scaling, two 256 byte tables c shared index:
doublescaletable1
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000000
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00000011
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001100
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00001111
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110000
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00110011
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111100
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%00111111
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000000
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11000011
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001100
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11001111
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110000
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11110011
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111100
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111
 .byte #%11111111

doublescaletable2
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111
 .byte #%00000000
 .byte #%00000011
 .byte #%00001100
 .byte #%00001111
 .byte #%00110000
 .byte #%00110011
 .byte #%00111100
 .byte #%00111111
 .byte #%11000000
 .byte #%11000011
 .byte #%11001100
 .byte #%11001111
 .byte #%11110000
 .byte #%11110011
 .byte #%11111100
 .byte #%11111111


;---end double scaling hardware tables (2)



;align data statements
DYNAMICSTATICRAMARRAYS ; ---- at the top, 254 bytes until pagebreak (the nop) must put a spacer in after that 
 ; --- 4K for user arrays should be enough even in commodore 64 Atari 2600 emulation land with graphcis overloading too boot!

 ;------------------------------------------------------tiny aligned tables:
 org 25600 ; page align tiny tables

; c64playfieldlookup; is like this:
;  ;mirrors quadrant handler for the rows (repeats 4x)
;  .byte 0,80,160,0,80,160,0,80,160,0,80,160

c64playfieldlookupxoffset
   .byte 0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38
; c64playfieldlookupbitposx
   .byte 0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7,0,1,2,3

playfieldlookup  ; used for fast * to replace fast calc: asl asl + + (for multiply x6) with faster lookup :)
 ;20160525 revising from y to x axis.byte 0,6,12,18,24,30,36,42,48,54
 .byte 0,0,10,10,10,10,20,20,20,20,30,30,40,40,40,40,50,50,50,50

c64playfieldlookup
  ;mirrors quadrant handler for the rows (repeats 4x)
 .byte 0,80,160,0,80,160,0,80,160,0,80,160


fastyindex
 .byte #0
 .byte #12
 .byte #24
 .byte #36
 .byte #48
 .byte #60
 .byte #72
 .byte #84
 .byte #96
 .byte #108
 .byte #120
 .byte #132
 .byte #144
 .byte #156
 .byte #168
 .byte #180
 .byte #192
 .byte #204
 .byte #216
 .byte #228 ; = bityindex .byte 0,12,24,36,48,60,72,84,96,108,120,132,144,156,168,180,192,204,216,228

tenbytelookup
; .byte 9,10,20,30,40,50,60,70,80,90
;adjustd:
 .byte 11,17,27,37,47,56,66,76,86,96


;-------------end page align tiny tables (<=256 bytes total)


 org 25856 ;
Atari2600C64HorizontalPositioningMap
atari2600C64HorizontalPositioningMap
 .byte 	8
 .byte 	10
 .byte 	12
 .byte 	14
 .byte 	16
 .byte 	18
 .byte 	20
 .byte 	22
 .byte 	24
 .byte 	26
 .byte 	28
 .byte 	30
 .byte 	32
 .byte 	34
 .byte 	36
 .byte 	38
 .byte 	40
 .byte 	42
 .byte 	44
 .byte 	46
 .byte 	48
 .byte 	50
 .byte 	52
 .byte 	54
 .byte 	56
 .byte 	58
 .byte 	60
 .byte 	62
 .byte 	64
 .byte 	66
 .byte 	68
 .byte 	70
 .byte 	72
 .byte 	74
 .byte 	76
 .byte 	78
 .byte 	80
 .byte 	82
 .byte 	84
 .byte 	86
 .byte 	88
 .byte 	90
 .byte 	92
 .byte 	94
 .byte 	96
 .byte 	98
 .byte 	100
 .byte 	102
 .byte 	104
 .byte 	106
 .byte 	108
 .byte 	110
 .byte 	112
 .byte 	114
 .byte 	116
 .byte 	118
 .byte 	120
 .byte 	122
 .byte 	124
 .byte 	126
 .byte 	128
 .byte 	130
 .byte 	132
 .byte 	134
 .byte 	136
 .byte 	138
 .byte 	140
 .byte 	142
 .byte 	144
 .byte 	146
 .byte 	148
 .byte 	150
 .byte 	152
 .byte 	154
 .byte 	156
 .byte 	158
 .byte 	160
 .byte 	162
 .byte 	164
 .byte 	166
 .byte 	168
 .byte 	170
 .byte 	172
 .byte 	174
 .byte 	176
 .byte 	178
 .byte 	180
 .byte 	182
 .byte 	184
 .byte 	186
 .byte 	188
 .byte 	190
 .byte 	192
 .byte 	194
 .byte 	196
 .byte 	198
 .byte 	200
 .byte 	202
 .byte 	204
 .byte 	206
 .byte 	208
 .byte 	210
 .byte 	212
 .byte 	214
 .byte 	216
 .byte 	218
 .byte 	220
 .byte 	222
 .byte 	224
 .byte 	226
 .byte 	228
 .byte 	230
 .byte 	232
 .byte 	234
 .byte 	236
 .byte 	238
 .byte 	240
 .byte 	242
 .byte 	244
 .byte 	246
 .byte 	248
 .byte 	249
 .byte 	250
 .byte 	251;254 ; ---- 20220523 offset somewhere is 250 not 255 checking where
 .byte 	252;256
 .byte 	253;258
 .byte 	254;260
 .byte 	254;262
 .byte 	3
 .byte 	6
 .byte 	9
 .byte 	12
 .byte 	15
 .byte 	18
 .byte 	20
 .byte 	22
 .byte 	24
 .byte 	26
 .byte 	28
 .byte 	30
 .byte 	32
 .byte 	34
 .byte 	36
 .byte 	38
 .byte 	40
 .byte 	42
 .byte 	44
 .byte 	46
 .byte 	48
 .byte 	50
 .byte 	52
 .byte 	54
 .byte 	56
 .byte 	58
 .byte 	60
 .byte 	62
 .byte 	64
 .byte 	66
 .byte 	68
 .byte 	70
 .byte 	72
 .byte 	74
 .byte 	76
 .byte 	78
 .byte 	80
 .byte  82
 .byte  84
 .byte  86
 .byte  88
 .byte  90
 .byte  92
 .byte 100
 .byte 102
 .byte 104
 .byte 106
 .byte 108
 .byte 110
 .byte 112

;-------------end Atari2600C64HorizontalPositioningMap
 org 26112 ; 25856+256 ... make sure table above does not overlap

Atari2600C64VertialPositioningMap
Atari2600C64VerticalPositioningMap
 .byte 	213
 .byte 	212
 .byte 	211
 .byte 	210
 .byte 	209
 .byte 	208
 .byte 	207
 .byte 	206
 .byte 	205
 .byte 	204
 .byte 	203
 .byte 	202
 .byte 	201
 .byte 	200
 .byte 	198
 .byte 	196 ; ---
 .byte 	194
 .byte 	192
 .byte 	190
 .byte 	188
 .byte 	186 ;---
 .byte 	184
 .byte 	182
 .byte 	180
 .byte 	178
 .byte 	176 ;----
 .byte 	174
 .byte 	172
 .byte 	170
 .byte 	168
 .byte 	166 ;----
 .byte 	164
 .byte 	162
 .byte 	160
 .byte 	158
 .byte 	156; ----
 .byte 	154
 .byte 	152; -- 37 OK, adjust up 4px below:
 .byte 	151;
 .byte 	150;
 .byte 	149;
 .byte 	148
 .byte 	146
 .byte 	144 ;? which way one below...
 .byte 	142;  now correct...   126 
 .byte 	140;124
 .byte 	138;122
 .byte 	136;120  fix 47...
 .byte 	134;118
 .byte 	132;116
 .byte 	130;114
 .byte 	128;112
 .byte 	126;110
 .byte 	124;108
 .byte 	122;106
 .byte 	120;104
 .byte 	118;102  fix 56...
 .byte 	117;100
 .byte 	116;98
 .byte 	114;96
 .byte 112
 .byte 110
 .byte 109
 .byte 108
 .byte 107
 .byte 106
 .byte 105; fix 66....
 .byte 103
 .byte 101
 .byte 99
 .byte 97
 .byte 95
 .byte 93
 .byte 91
 .byte 89
 .byte 87
 .byte 85
 .byte 83 ; 77
 
 .byte 82
 .byte 81
 .byte 80
 .byte 79
 .byte 78
 .byte 76
 .byte 74
 .byte 72
 .byte 70 ; 86
 .byte 68
 .byte 66
 .BYTE 64
 .byte 63
 .byte 62
 .byte 60
 .byte 59
 .byte 58
 .byte 57
 .byte 56 ; 96 ; ----done, remaining are overflow or tx to 0:
 .byte 55
 .byte 54
 .byte 53
 .byte 52
 .byte 51
 .byte 50
 .byte 49
 .byte 48
 .byte 47
 .byte 46
 .byte 45; should never get here
 .byte 45; should never get here
   

   ;20220529 test 
   org 26368
GameLoop ;----------------------------- 2K game loop! [5k on C64]

;---imported block

replacegameloopcode

;---end imported block

; jmp GameLoopReturn ;
 rts
     ;---------------------------
;    ;---- end gameloop
     ;---------------------------

 org 31488; ------------------------- 5K past gameloop1 
;-----------------------------------------------
;-----------------------------------------------------------
GameLoop2
;-----------------------------------------------------------
;--- game loop for the bottom blank

;-----------------------------------------------------------
replacegameloop2code


doneGameLoop2
; jmp GameLoop2RETURN;+stack
 rts ;    --------------------- End GameLoop2
